/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.operator;

import eu.stratosphere.api.common.functions.AbstractFunction;
import eu.stratosphere.api.common.functions.Function;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Ordering;
import eu.stratosphere.api.common.operators.base.CoGroupOperatorBase;
import eu.stratosphere.api.common.operators.base.CrossOperatorBase;
import eu.stratosphere.api.common.operators.base.JoinOperatorBase;
import eu.stratosphere.api.common.operators.base.MapOperatorBase;
import eu.stratosphere.api.common.operators.base.ReduceOperatorBase;
import eu.stratosphere.api.common.operators.util.OperatorUtil;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.pact.common.IdentityMap;
import eu.stratosphere.pact.common.plan.PactModule;
import eu.stratosphere.sopremo.AbstractSopremoType;
import eu.stratosphere.sopremo.EvaluationContext;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.InputSelection;
import eu.stratosphere.sopremo.expressions.OrderingExpression;
import eu.stratosphere.sopremo.io.Sink;
import eu.stratosphere.sopremo.operator.ElementarySopremoModule;
import eu.stratosphere.sopremo.operator.JsonStream;
import eu.stratosphere.sopremo.operator.Name;
import eu.stratosphere.sopremo.operator.Operator;
import eu.stratosphere.sopremo.operator.OutputCardinality;
import eu.stratosphere.sopremo.operator.Property;
import eu.stratosphere.sopremo.pact.SopremoCoGroupOperator;
import eu.stratosphere.sopremo.pact.SopremoReduceOperator;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.serialization.SopremoRecordLayout;
import eu.stratosphere.util.CollectionUtil;
import eu.stratosphere.util.IdentityList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@OutputCardinality(min=1, max=1)
public abstract class ElementaryOperator<Self extends ElementaryOperator<Self>>
extends Operator<Self> {
    private final List<List<? extends EvaluationExpression>> keyExpressions = new ArrayList<List<? extends EvaluationExpression>>();
    private final List<List<OrderingExpression>> innerGroupOrders = new ArrayList<List<OrderingExpression>>();
    private EvaluationExpression resultProjection = EvaluationExpression.VALUE;
    private boolean combinable;
    private boolean combinableFirst;
    private boolean combinableSecond;

    public ElementaryOperator() {
        int index;
        for (index = 0; index < this.getMinInputs(); ++index) {
            this.keyExpressions.add(new ArrayList());
        }
        for (index = 0; index < this.getMinInputs(); ++index) {
            this.innerGroupOrders.add(new ArrayList());
        }
        this.combinable = false;
        this.combinableFirst = false;
        this.combinableSecond = false;
    }

    public ElementaryOperator(int inputs) {
        this(inputs, inputs);
    }

    public ElementaryOperator(int minInputs, int maxInputs) {
        super(minInputs, maxInputs, 1, 1);
        int index;
        for (index = 0; index < this.getMinInputs(); ++index) {
            this.keyExpressions.add(new ArrayList());
        }
        for (index = 0; index < this.getMinInputs(); ++index) {
            this.innerGroupOrders.add(new ArrayList());
        }
        this.combinable = false;
        this.combinableFirst = false;
        this.combinableSecond = false;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        super.appendAsString(appendable);
        if (this.getResultProjection() != EvaluationExpression.VALUE) {
            appendable.append(" to ");
            this.getResultProjection().appendAsString(appendable);
        }
    }

    @Override
    public ElementarySopremoModule asElementaryOperators() {
        ElementarySopremoModule module = new ElementarySopremoModule(this.getInputs().size(), this.getOutputs().size());
        module.setName(this.toString());
        AbstractSopremoType clone = this.clone();
        for (int index = 0; index < this.getInputs().size(); ++index) {
            ((Operator)clone).setInput(index, (JsonStream)module.getInput(index));
        }
        List<JsonStream> outputs = ((Operator)clone).getOutputs();
        for (int index = 0; index < outputs.size(); ++index) {
            ((Sink)module.getOutput(index)).setInput(index, outputs.get(index));
        }
        return module;
    }

    public PactModule asPactModule(EvaluationContext context, SopremoRecordLayout layout) {
        eu.stratosphere.api.common.operators.Operator contract = this.getOperator(layout);
        context.setResultProjection(this.resultProjection);
        this.configureOperator(contract, contract.getParameters(), context, layout);
        List inputLists = OperatorUtil.getInputs((eu.stratosphere.api.common.operators.Operator)contract);
        IdentityList distinctInputs = new IdentityList();
        for (List inputs : inputLists) {
            if (inputs.isEmpty()) {
                inputs.add(new MapOperatorBase(IdentityMap.class, "nop"));
            }
            for (eu.stratosphere.api.common.operators.Operator input : inputs) {
                if (distinctInputs.contains(input)) continue;
                distinctInputs.add(input);
            }
        }
        PactModule module = new PactModule(distinctInputs.size(), 1);
        for (List inputs : inputLists) {
            for (int index = 0; index < inputs.size(); ++index) {
                inputs.set(index, module.getInput(distinctInputs.indexOf(inputs.get(index))));
            }
        }
        OperatorUtil.setInputs((eu.stratosphere.api.common.operators.Operator)contract, (List)inputLists);
        ((GenericDataSink)module.getOutput(0)).addInput(contract);
        return module;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementaryOperator other = (ElementaryOperator)obj;
        return this.keyExpressions.equals(other.keyExpressions) && this.innerGroupOrders.equals(other.innerGroupOrders) && this.resultProjection.equals(other.resultProjection);
    }

    public Set<EvaluationExpression> getAllKeyExpressions() {
        HashSet<EvaluationExpression> allKeys = new HashSet<EvaluationExpression>();
        List<JsonStream> inputs = this.getInputs();
        for (int index = 0; index < inputs.size(); ++index) {
            allKeys.addAll(this.getKeyExpressions(index));
            for (OrderingExpression orderingExpression : this.getInnerGroupOrder(index)) {
                allKeys.add(orderingExpression.getPath());
            }
        }
        return allKeys;
    }

    public List<OrderingExpression> getInnerGroupOrder(int inputIndex) {
        if (inputIndex >= this.innerGroupOrders.size()) {
            return Collections.EMPTY_LIST;
        }
        List<OrderingExpression> innerGroupOrder = this.innerGroupOrders.get(inputIndex);
        if (innerGroupOrder == null) {
            return Collections.EMPTY_LIST;
        }
        return innerGroupOrder;
    }

    public List<? extends EvaluationExpression> getKeyExpressions(int inputIndex) {
        if (inputIndex >= this.keyExpressions.size()) {
            return Collections.EMPTY_LIST;
        }
        List<? extends EvaluationExpression> expressions = this.keyExpressions.get(inputIndex);
        if (expressions == null) {
            return Collections.EMPTY_LIST;
        }
        return expressions;
    }

    public EvaluationExpression getResultProjection() {
        return this.resultProjection;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.keyExpressions.hashCode();
        result = 31 * result + this.innerGroupOrders.hashCode();
        result = 31 * result + this.resultProjection.hashCode();
        return result;
    }

    public boolean isCombinable() {
        return this.combinable;
    }

    public boolean isCombinableFirst() {
        return this.combinableFirst;
    }

    public boolean isCombinableSecond() {
        return this.combinableSecond;
    }

    public void setCombinable(boolean combinable) {
        this.combinable = combinable;
    }

    public void setCombinableFirst(boolean combinableFirst) {
        this.combinableFirst = combinableFirst;
    }

    public void setCombinableSecond(boolean combinableSecond) {
        this.combinableSecond = combinableSecond;
    }

    public void setInnerGroupOrder(int inputIndex, List<OrderingExpression> innerGroupOrder) {
        if (innerGroupOrder == null) {
            throw new NullPointerException("innerGroupOrders must not be null");
        }
        CollectionUtil.ensureSize(this.innerGroupOrders, (int)(inputIndex + 1));
        this.innerGroupOrders.set(inputIndex, new ArrayList<OrderingExpression>(innerGroupOrder));
    }

    public void setInnerGroupOrder(int inputIndex, OrderingExpression ... innerGroupOrder) {
        if (innerGroupOrder == null) {
            throw new NullPointerException("innerGroupOrders must not be null");
        }
        this.setInnerGroupOrder(inputIndex, Arrays.asList(innerGroupOrder));
    }

    public void setKeyExpressions(int index, EvaluationExpression ... keyExpressions) {
        if (keyExpressions.length == 0) {
            throw new IllegalArgumentException("keyExpressions must not be null");
        }
        this.setKeyExpressions(index, Arrays.asList(keyExpressions));
    }

    public void setKeyExpressions(int inputIndex, List<? extends EvaluationExpression> keyExpressions) {
        if (keyExpressions == null) {
            throw new NullPointerException("keyExpressions must not be null");
        }
        CollectionUtil.ensureSize(this.keyExpressions, (int)(inputIndex + 1));
        this.keyExpressions.set(inputIndex, new ArrayList<EvaluationExpression>(keyExpressions));
    }

    @Property
    @Name(preposition={"into"})
    public void setResultProjection(EvaluationExpression resultProjection) {
        if (resultProjection == null) {
            throw new NullPointerException("resultProjection must not be null");
        }
        this.resultProjection = this.getMaxInputs() == 1 ? resultProjection.clone().remove(new InputSelection(0)) : resultProjection;
    }

    public Self withCombinable(boolean combinable) {
        this.setCombinable(combinable);
        return (Self)((ElementaryOperator)this.self());
    }

    public Self withCombinableFirst(boolean combinableFirst) {
        this.combinableFirst = combinableFirst;
        return (Self)((ElementaryOperator)this.self());
    }

    public void withCombinableSecond(boolean combinableSecond) {
        this.combinableSecond = combinableSecond;
    }

    public Self withInnerGroupOrdering(int index, List<OrderingExpression> innerGroupOrder) {
        this.setInnerGroupOrder(index, innerGroupOrder);
        return (Self)((ElementaryOperator)this.self());
    }

    public Self withInnerGroupOrdering(int index, OrderingExpression ... innerGroupOrder) {
        this.setInnerGroupOrder(index, innerGroupOrder);
        return (Self)((ElementaryOperator)this.self());
    }

    public Self withKeyExpression(int index, EvaluationExpression ... keyExpressions) {
        this.setKeyExpressions(index, keyExpressions);
        return (Self)((ElementaryOperator)this.self());
    }

    public Self withKeyExpressions(int index, List<? extends EvaluationExpression> keyExpressions) {
        this.setKeyExpressions(index, keyExpressions);
        return (Self)((ElementaryOperator)this.self());
    }

    public Self withResultProjection(EvaluationExpression resultProjection) {
        this.setResultProjection(resultProjection);
        return (Self)((ElementaryOperator)this.self());
    }

    protected void configureOperator(eu.stratosphere.api.common.operators.Operator contract, Configuration stubConfiguration, EvaluationContext context, SopremoRecordLayout layout) {
        SopremoUtil.transferFieldsToConfiguration(this, ElementaryOperator.class, stubConfiguration, contract.getUserCodeWrapper().getUserCodeClass(), AbstractFunction.class);
        contract.setDegreeOfParallelism(this.getDegreeOfParallelism());
        SopremoUtil.setEvaluationContext(stubConfiguration, context);
    }

    protected Ordering createOrdering(SopremoRecordLayout layout, List<OrderingExpression> innerGroupOrder) {
        ArrayList<EvaluationExpression> paths = new ArrayList<EvaluationExpression>();
        for (OrderingExpression orderingExpression : innerGroupOrder) {
            paths.add(orderingExpression.getPath());
        }
        int[] keyIndices = this.getKeyIndices(layout, paths);
        Ordering ordering = new Ordering();
        for (int index = 0; index < keyIndices.length; ++index) {
            ordering.appendOrdering(Integer.valueOf(keyIndices[index]), null, innerGroupOrder.get(index).getOrder());
        }
        return ordering;
    }

    protected PactModule createShortCircuitModule() {
        PactModule module = new PactModule(1, 1);
        ((GenericDataSink)module.getOutput(0)).setInput((eu.stratosphere.api.common.operators.Operator)module.getInput(0));
        return module;
    }

    protected Class<? extends Function> getFunctionClass() {
        for (Class<?> stubClass : this.getClass().getDeclaredClasses()) {
            if ((stubClass.getModifiers() & 8) == 0 || !Function.class.isAssignableFrom(stubClass)) continue;
            return stubClass;
        }
        return null;
    }

    protected int[] getKeyIndices(SopremoRecordLayout sopremoRecordLayout, Iterable<? extends EvaluationExpression> keyExpressions) {
        IntOpenHashSet keyIndices = new IntOpenHashSet();
        for (EvaluationExpression evaluationExpression : keyExpressions) {
            keyIndices.addAll(sopremoRecordLayout.indicesOf(evaluationExpression));
        }
        if (keyIndices.isEmpty()) {
            if (keyExpressions.iterator().hasNext()) {
                throw new IllegalStateException(String.format("Operator %s did not specify key expression that it now requires", this.getClass()));
            }
            throw new IllegalStateException(String.format("Needs to specify key expressions: %s", this.getClass()));
        }
        return keyIndices.toIntArray();
    }

    protected eu.stratosphere.api.common.operators.Operator getOperator(SopremoRecordLayout layout) {
        Class<Function> stubClass = this.getFunctionClass();
        if (stubClass == null) {
            throw new IllegalStateException("no implementing stub found");
        }
        Class contractClass = OperatorUtil.getContractClass(stubClass);
        if (contractClass == null) {
            throw new IllegalStateException("no associated contract found");
        }
        String name = this.toString();
        try {
            if (contractClass == ReduceOperatorBase.class) {
                int[] keyIndices = this.getKeyIndices(layout, this.getKeyExpressions(0));
                SopremoReduceOperator contract = new SopremoReduceOperator(this, stubClass, keyIndices, name);
                if (!this.getInnerGroupOrder(0).isEmpty()) {
                    contract.setInnerGroupOrder(this.createOrdering(layout, this.getInnerGroupOrder(0)));
                }
                return contract;
            }
            if (contractClass == CoGroupOperatorBase.class) {
                int[] keyIndices1 = this.getKeyIndices(layout, this.getKeyExpressions(0));
                int[] keyIndices2 = this.getKeyIndices(layout, this.getKeyExpressions(1));
                SopremoCoGroupOperator contract = new SopremoCoGroupOperator(this, stubClass, keyIndices1, keyIndices2, name);
                if (!this.getInnerGroupOrder(0).isEmpty()) {
                    contract.setFirstInnerGroupOrdering(this.createOrdering(layout, this.getInnerGroupOrder(0)));
                }
                if (!this.getInnerGroupOrder(1).isEmpty()) {
                    contract.setFirstInnerGroupOrdering(this.createOrdering(layout, this.getInnerGroupOrder(1)));
                }
                return contract;
            }
            if (contractClass == JoinOperatorBase.class) {
                int[] keyIndices1 = this.getKeyIndices(layout, this.getKeyExpressions(0));
                int[] keyIndices2 = this.getKeyIndices(layout, this.getKeyExpressions(1));
                return new JoinOperatorBase(stubClass, keyIndices1, keyIndices2, name);
            }
            if (contractClass == MapOperatorBase.class) {
                return new MapOperatorBase(stubClass, name);
            }
            if (contractClass == CrossOperatorBase.class) {
                return new CrossOperatorBase(stubClass, name);
            }
            throw new UnsupportedOperationException("Unknown contract type");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create contract from stub " + stubClass, e);
        }
    }
}

