/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.operator;

import eu.stratosphere.sopremo.operator.ElementarySopremoModule;
import eu.stratosphere.sopremo.operator.Operator;
import eu.stratosphere.sopremo.operator.SopremoModule;

public abstract class CompositeOperator<Self extends CompositeOperator<Self>>
extends Operator<Self> {
    public CompositeOperator() {
    }

    public CompositeOperator(int numberOfInputs, int numberOfOutputs) {
        super(numberOfInputs, numberOfInputs, numberOfOutputs, numberOfOutputs);
    }

    public CompositeOperator(int minInputs, int maxInputs, int minOutputs, int maxOutputs) {
        super(minInputs, maxInputs, minOutputs, maxOutputs);
    }

    public abstract void addImplementation(SopremoModule var1);

    @Override
    public ElementarySopremoModule asElementaryOperators() {
        SopremoModule module = new SopremoModule(this.getNumInputs(), this.getNumOutputs());
        module.setName(this.getName());
        this.addImplementation(module);
        if (this.getDegreeOfParallelism() != -1) {
            for (Operator moduleOperator : module.getReachableNodes()) {
                if (moduleOperator.getDegreeOfParallelism() != -1) continue;
                moduleOperator.setDegreeOfParallelism(this.getDegreeOfParallelism());
            }
        }
        module.validate();
        return module.asElementary();
    }
}

