/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.io;

import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.GenericDataSource;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.pact.common.plan.PactModule;
import eu.stratosphere.sopremo.EvaluationContext;
import eu.stratosphere.sopremo.expressions.ArrayCreation;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.io.GeneratorInputFormat;
import eu.stratosphere.sopremo.io.JsonFormat;
import eu.stratosphere.sopremo.io.SopremoFormat;
import eu.stratosphere.sopremo.operator.ElementaryOperator;
import eu.stratosphere.sopremo.operator.InputCardinality;
import eu.stratosphere.sopremo.operator.Name;
import eu.stratosphere.sopremo.operator.Property;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.serialization.SopremoRecordLayout;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.NullNode;
import eu.stratosphere.util.Equaler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

@InputCardinality(value=0)
@Name(noun={"source"})
public class Source
extends ElementaryOperator<Source> {
    private String inputPath;
    private EvaluationExpression adhocExpression;
    private SopremoFormat format;

    public Source() {
        this(new ArrayCreation());
    }

    public Source(EvaluationExpression adhocValue) {
        this.adhocExpression = adhocValue;
        this.format = new JsonFormat();
    }

    public Source(SopremoFormat format) {
        this(format, null);
    }

    public Source(SopremoFormat format, String inputPath) {
        this.inputPath = inputPath;
        this.format = format;
        if (format.getInputFormat() == null) {
            throw new IllegalArgumentException("given format does not support reading");
        }
        if (this.inputPath != null) {
            this.checkPath();
        }
        this.addPropertiesFrom(this.format);
    }

    public Source(String inputPath) {
        this(new JsonFormat(), inputPath);
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append(this.getName()).append(" [");
        if (this.isAdhoc()) {
            this.adhocExpression.appendAsString(appendable);
        } else {
            if (this.inputPath != null) {
                appendable.append(this.inputPath).append(", ");
            }
            this.format.appendAsString(appendable);
        }
        appendable.append("]");
    }

    @Override
    public PactModule asPactModule(EvaluationContext context, SopremoRecordLayout layout) {
        GenericDataSource contract;
        String name = this.getName();
        if (this.isAdhoc()) {
            contract = new GenericDataSource(GeneratorInputFormat.class, String.format("Adhoc %s", name));
            SopremoUtil.setObject(contract.getParameters(), "sopremo.source.generator.expression", this.adhocExpression);
        } else {
            contract = new GenericDataSource(this.format.getInputFormat(), name);
            this.format.configureForInput(contract.getParameters(), contract, this.inputPath);
        }
        PactModule pactModule = new PactModule(0, 1);
        SopremoUtil.setEvaluationContext(contract.getParameters(), context);
        contract.setDegreeOfParallelism(this.getDegreeOfParallelism());
        ((GenericDataSink)pactModule.getOutput(0)).setInput((Operator)contract);
        return pactModule;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Source other = (Source)obj;
        return Equaler.SafeEquals.equal((Object)this.inputPath, (Object)other.inputPath) && Equaler.SafeEquals.equal((Object)this.format, (Object)other.format) && Equaler.SafeEquals.equal((Object)this.adhocExpression, (Object)other.adhocExpression);
    }

    public EvaluationExpression getAdhocExpression() {
        return this.adhocExpression;
    }

    public IJsonNode getAdhocValues() {
        if (!this.isAdhoc()) {
            throw new IllegalStateException();
        }
        return this.getAdhocExpression().evaluate(NullNode.getInstance());
    }

    public SopremoFormat getFormat() {
        return this.format;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.adhocExpression == null ? 0 : this.adhocExpression.hashCode());
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.inputPath == null ? 0 : this.inputPath.hashCode());
        return result;
    }

    public boolean isAdhoc() {
        return this.adhocExpression != null;
    }

    public void setAdhocExpression(EvaluationExpression adhocExpression) {
        if (adhocExpression == null) {
            throw new NullPointerException("adhocExpression must not be null");
        }
        this.inputPath = null;
        this.adhocExpression = adhocExpression;
    }

    @Property(preferred=true)
    public void setFormat(SopremoFormat format) {
        if (format == null) {
            throw new NullPointerException("format must not be null");
        }
        if (format.getInputFormat() == null) {
            throw new IllegalArgumentException("reading for the given format is not supported");
        }
        this.removePropertiesFrom(this.format);
        this.format = format;
        this.addPropertiesFrom(format);
    }

    public void setInputPath(String inputPath) {
        if (inputPath == null) {
            throw new NullPointerException("inputPath must not be null");
        }
        this.adhocExpression = null;
        this.inputPath = inputPath;
        this.checkPath();
    }

    private void checkPath() {
        try {
            URI uri = new URI(this.inputPath);
            if (uri.getScheme() == null) {
                throw new IllegalStateException("File name of source does not have a valid schema (such as hdfs or file): " + this.inputPath);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid path", e);
        }
    }
}

