/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.io;

import com.google.common.reflect.TypeToken;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.io.InputFormat;
import eu.stratosphere.api.common.io.OutputFormat;
import eu.stratosphere.api.common.io.statistics.BaseStatistics;
import eu.stratosphere.api.common.operators.GenericDataSource;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.core.fs.FSDataInputStream;
import eu.stratosphere.core.fs.FSDataOutputStream;
import eu.stratosphere.core.fs.FileInputSplit;
import eu.stratosphere.core.fs.FileStatus;
import eu.stratosphere.core.fs.FileSystem;
import eu.stratosphere.core.fs.Path;
import eu.stratosphere.core.io.InputSplit;
import eu.stratosphere.sopremo.EvaluationContext;
import eu.stratosphere.sopremo.SopremoEnvironment;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.operator.ConfigurableSopremoType;
import eu.stratosphere.sopremo.operator.Name;
import eu.stratosphere.sopremo.operator.Property;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.serialization.SopremoRecord;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;

public abstract class SopremoFormat
extends ConfigurableSopremoType {
    private String encoding = "utf-8";
    private EvaluationExpression projection = EvaluationExpression.VALUE;

    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append(this.getClass().getSimpleName());
    }

    public boolean canHandleFormat(URI uri) {
        String[] preferredFilenameExtensions = this.getPreferredFilenameExtensions();
        if (preferredFilenameExtensions.length == 0) {
            return false;
        }
        String uriPath = uri.toString();
        if (uriPath == null) {
            return false;
        }
        int separator = uriPath.lastIndexOf(".");
        if (separator == -1) {
            return false;
        }
        String ending = uriPath.substring(separator + 1);
        for (String extension : preferredFilenameExtensions) {
            if (!ending.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SopremoFormat clone() {
        return (SopremoFormat)super.clone();
    }

    public void configureForInput(Configuration configuration, GenericDataSource<?> source, String inputPath) {
        Class<? extends SopremoInputFormat<?>> inputFormat = this.getInputFormat();
        if (inputPath != null) {
            FileInputFormat.configureFileFormat(source).filePath(inputPath);
        } else if (FileInputFormat.class.isAssignableFrom(inputFormat)) {
            throw new IllegalStateException("No input path was given for the file input format");
        }
        SopremoUtil.transferFieldsToConfiguration(this, SopremoFormat.class, configuration, inputFormat, InputFormat.class);
    }

    public void configureForOutput(Configuration configuration, String outputPath) {
        Class<? extends SopremoOutputFormat> outputFormat = this.getOutputFormat();
        if (outputPath != null) {
            configuration.setString("pact.output.file", outputPath);
        } else if (FileOutputFormat.class.isAssignableFrom(outputFormat)) {
            throw new IllegalStateException("No input path was given for the file input format");
        }
        SopremoUtil.transferFieldsToConfiguration(this, SopremoFormat.class, configuration, outputFormat, OutputFormat.class);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SopremoFormat other = (SopremoFormat)obj;
        return this.encoding.equals(other.encoding);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Class<? extends SopremoInputFormat<?>> getInputFormat() {
        for (Class<?> formatClass : this.getClass().getDeclaredClasses()) {
            if ((formatClass.getModifiers() & 8) == 0 || !InputFormat.class.isAssignableFrom(formatClass)) continue;
            TypeToken typeToken = TypeToken.of(formatClass).getSupertype(InputFormat.class);
            if (((ParameterizedType)typeToken.getType()).getActualTypeArguments()[0] != SopremoRecord.class) {
                throw new IllegalStateException("Found input format but does not process " + SopremoRecord.class.getSimpleName());
            }
            return formatClass;
        }
        return null;
    }

    public Class<? extends SopremoOutputFormat> getOutputFormat() {
        for (Class<?> formatClass : this.getClass().getDeclaredClasses()) {
            if ((formatClass.getModifiers() & 8) == 0 || !OutputFormat.class.isAssignableFrom(formatClass)) continue;
            TypeToken typeToken = TypeToken.of(formatClass).getSupertype(OutputFormat.class);
            if (((ParameterizedType)typeToken.getType()).getActualTypeArguments()[0] != SopremoRecord.class) {
                throw new IllegalStateException("Found output format but does not process " + SopremoRecord.class.getSimpleName());
            }
            return formatClass;
        }
        return null;
    }

    public EvaluationExpression getProjection() {
        return this.projection;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.encoding.hashCode();
        return result;
    }

    @Property
    @Name(noun={"encoding"})
    public void setEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException("encoding must not be null");
        }
        this.encoding = Charset.forName(encoding).name();
    }

    @Property
    @Name(preposition={"into"})
    public void setProjection(EvaluationExpression projection) {
        if (projection == null) {
            throw new NullPointerException("projection must not be null");
        }
        this.projection = projection;
    }

    public SopremoFormat withEncoding(String encoding) {
        this.setEncoding(encoding);
        return this;
    }

    protected String[] getPreferredFilenameExtensions() {
        return new String[0];
    }

    public static interface SopremoOutputFormat
    extends OutputFormat<SopremoRecord> {
        public void writeValue(IJsonNode var1) throws IOException;
    }

    public static interface SopremoInputFormat<T extends InputSplit>
    extends InputFormat<SopremoRecord, T> {
        public IJsonNode nextValue() throws IOException;
    }

    public static abstract class SopremoFileOutputFormat
    extends FileOutputFormat<SopremoRecord>
    implements SopremoOutputFormat {
        private static final long serialVersionUID = 4820322749775824947L;
        private EvaluationContext context;
        private String encoding;

        public void configure(Configuration parameters) {
            super.configure(parameters);
            SopremoEnvironment.getInstance().setConfiguration(parameters);
            this.context = SopremoEnvironment.getInstance().getEvaluationContext();
            SopremoUtil.configureWithTransferredState(this, SopremoFileInputFormat.class, parameters);
        }

        public void open(int taskNumber) throws IOException {
            super.open(taskNumber);
            this.open(this.stream, taskNumber);
        }

        public void writeRecord(SopremoRecord record) throws IOException {
            IJsonNode value = record.getOrParseNode();
            if (SopremoUtil.LOG.isTraceEnabled()) {
                SopremoUtil.LOG.trace((Object)String.format("%s output %s", this.context.getOperatorDescription(), value));
            }
            this.writeValue(value);
        }

        protected EvaluationContext getContext() {
            return this.context;
        }

        protected String getEncoding() {
            return this.encoding;
        }

        protected abstract void open(FSDataOutputStream var1, int var2) throws IOException;
    }

    public static abstract class SopremoFileInputFormat
    extends FileInputFormat<SopremoRecord>
    implements SopremoInputFormat<FileInputSplit> {
        private static final long serialVersionUID = -4311506385230408263L;
        private boolean end;
        private String encoding;
        private EvaluationExpression projection;

        public void configure(Configuration parameters) {
            super.configure(parameters);
            SopremoEnvironment.getInstance().setConfiguration(parameters);
            SopremoUtil.configureWithTransferredState(this, SopremoFileInputFormat.class, parameters);
        }

        public FileInputFormat.FileBaseStatistics getStatistics(BaseStatistics cachedStatistics) throws IOException {
            FileInputFormat.FileBaseStatistics fileStatistics;
            ArrayList<FileStatus> files = this.getFileStati();
            long latestModTime = files.get(0).getModificationTime();
            for (int index = 1; index < files.size(); ++index) {
                latestModTime = Math.max(files.get(index).getModificationTime(), latestModTime);
            }
            if (cachedStatistics != null && cachedStatistics instanceof FileInputFormat.FileBaseStatistics && latestModTime <= (fileStatistics = (FileInputFormat.FileBaseStatistics)cachedStatistics).getLastModificationTime()) {
                return fileStatistics;
            }
            long len = 0L;
            for (FileStatus s : files) {
                len += s.getLen();
            }
            return new FileInputFormat.FileBaseStatistics(latestModTime, len, this.getAverageRecordBytes(FileSystem.get((URI)this.filePath.toUri()), files, len));
        }

        public boolean nextRecord(SopremoRecord record) throws IOException {
            IJsonNode value;
            if (!this.end && (value = this.nextValue()) != null) {
                if (SopremoUtil.LOG.isTraceEnabled()) {
                    SopremoUtil.LOG.trace((Object)String.format("%s input %s", SopremoEnvironment.getInstance().getEvaluationContext().getOperatorDescription(), value));
                }
                record.setNode(this.projection.evaluate(value));
                return true;
            }
            return false;
        }

        public void open(FileInputSplit split) throws IOException {
            super.open(split);
            this.end = false;
            this.open(this.stream, split);
        }

        public boolean reachedEnd() {
            return this.end;
        }

        protected void endReached() {
            this.end = true;
        }

        protected float getAverageRecordBytes(FileSystem fileSystem, ArrayList<FileStatus> files, long fileSize) throws IOException {
            return -1.0f;
        }

        protected String getDefaultEncoding() {
            return "utf-8";
        }

        protected String getEncoding() {
            return this.encoding;
        }

        protected ArrayList<FileStatus> getFileStati() throws IOException {
            Path filePath = this.filePath;
            FileSystem fs = FileSystem.get((URI)filePath.toUri());
            FileStatus file = fs.getFileStatus(filePath);
            ArrayList<FileStatus> files = new ArrayList<FileStatus>(1);
            if (file.isDir()) {
                FileStatus[] fss = fs.listStatus(filePath);
                files.ensureCapacity(fss.length);
                for (FileStatus s : fss) {
                    if (s.isDir()) continue;
                    files.add(s);
                }
            } else {
                files.add(file);
            }
            return files;
        }

        protected abstract void open(FSDataInputStream var1, FileInputSplit var2) throws IOException;
    }

    public static abstract class AbstractSopremoInputFormat<T extends InputSplit>
    implements SopremoInputFormat<T> {
        private static final long serialVersionUID = -7383077858448406898L;
        private boolean end;
        private String encoding;
        private EvaluationExpression projection;

        public void configure(Configuration parameters) {
            SopremoEnvironment.getInstance().setConfiguration(parameters);
            SopremoUtil.configureWithTransferredState(this, SopremoFileInputFormat.class, parameters);
        }

        public boolean nextRecord(SopremoRecord record) throws IOException {
            if (!this.end) {
                IJsonNode value = this.nextValue();
                if (SopremoUtil.LOG.isTraceEnabled()) {
                    SopremoUtil.LOG.trace((Object)String.format("%s input %s", SopremoEnvironment.getInstance().getEvaluationContext().getOperatorDescription(), value));
                }
                record.setNode(this.projection.evaluate(value));
                return true;
            }
            return false;
        }

        public void open(T split) throws IOException {
            this.end = false;
        }

        public boolean reachedEnd() throws IOException {
            return this.end;
        }

        protected void endReached() {
            this.end = true;
        }

        protected String getDefaultEncoding() {
            return "utf-8";
        }

        protected String getEncoding() {
            return this.encoding;
        }
    }
}

