/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.io;

import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.pact.common.plan.PactModule;
import eu.stratosphere.sopremo.EvaluationContext;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OrderingExpression;
import eu.stratosphere.sopremo.io.JsonFormat;
import eu.stratosphere.sopremo.io.SopremoFormat;
import eu.stratosphere.sopremo.operator.ElementaryOperator;
import eu.stratosphere.sopremo.operator.ElementarySopremoModule;
import eu.stratosphere.sopremo.operator.InputCardinality;
import eu.stratosphere.sopremo.operator.JsonStream;
import eu.stratosphere.sopremo.operator.Name;
import eu.stratosphere.sopremo.operator.Operator;
import eu.stratosphere.sopremo.operator.OutputCardinality;
import eu.stratosphere.sopremo.operator.Property;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.serialization.SopremoRecordLayout;
import eu.stratosphere.util.Equaler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@InputCardinality(value=1)
@OutputCardinality(value=0)
@Name(noun={"sink"})
public class Sink
extends ElementaryOperator<Sink> {
    private String outputPath;
    private SopremoFormat format;
    private List<OrderingExpression> globalSortingKey = new ArrayList<OrderingExpression>();
    private List<OrderingExpression> localSortingKey = new ArrayList<OrderingExpression>();

    public Sink() {
        this("file:///");
    }

    public Sink(SopremoFormat format) {
        this(format, null);
    }

    public Sink(SopremoFormat format, String outputPath) {
        this.format = format;
        this.outputPath = outputPath;
        if (format.getOutputFormat() == null) {
            throw new IllegalArgumentException("given format does not support writing");
        }
        this.checkPath();
        this.addPropertiesFrom(format);
    }

    public Sink(String outputPath) {
        this(new JsonFormat(), outputPath);
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append(this.getName());
        appendable.append(" [");
        if (this.outputPath != null) {
            appendable.append(this.outputPath).append(", ");
        }
        this.format.appendAsString(appendable);
        appendable.append("]");
    }

    @Override
    public ElementarySopremoModule asElementaryOperators() {
        ElementarySopremoModule module = new ElementarySopremoModule(1, 0);
        Sink clone = (Sink)this.clone();
        module.addInternalOutput(clone);
        clone.setInput(0, (JsonStream)module.getInput(0));
        return module;
    }

    @Override
    public PactModule asPactModule(EvaluationContext context, SopremoRecordLayout layout) {
        PactModule pactModule = new PactModule(1, 0);
        Class<? extends SopremoFormat.SopremoOutputFormat> outputFormat = this.format.getOutputFormat();
        GenericDataSink contract = new GenericDataSink(outputFormat, this.getName());
        this.format.configureForOutput(contract.getParameters(), this.outputPath);
        SopremoUtil.setEvaluationContext(contract.getParameters(), context);
        contract.setDegreeOfParallelism(this.getDegreeOfParallelism());
        contract.setInput((Operator)pactModule.getInput(0));
        if (!this.globalSortingKey.isEmpty()) {
            contract.setGlobalOrder(this.createOrdering(layout, this.globalSortingKey));
        }
        if (!this.localSortingKey.isEmpty()) {
            contract.setLocalOrder(this.createOrdering(layout, this.localSortingKey));
        }
        pactModule.addInternalOutput(contract);
        return pactModule;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sink other = (Sink)obj;
        return Equaler.SafeEquals.equal((Object)this.outputPath, (Object)other.outputPath) && Equaler.SafeEquals.equal((Object)this.format, (Object)other.format);
    }

    @Override
    public Set<EvaluationExpression> getAllKeyExpressions() {
        Set<EvaluationExpression> allKeyExpressions = super.getAllKeyExpressions();
        for (OrderingExpression ordering : this.globalSortingKey) {
            allKeyExpressions.add(ordering.getPath());
        }
        for (OrderingExpression ordering : this.localSortingKey) {
            allKeyExpressions.add(ordering.getPath());
        }
        return allKeyExpressions;
    }

    public SopremoFormat getFormat() {
        return this.format;
    }

    public List<OrderingExpression> getGlobalSortingKey() {
        return this.globalSortingKey;
    }

    public List<OrderingExpression> getLocalSortingKey() {
        return this.localSortingKey;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    @Override
    public Operator.Output getSource() {
        throw new UnsupportedOperationException("Sink has not output");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.outputPath == null ? 0 : this.outputPath.hashCode());
        return result;
    }

    @Property(preferred=true)
    public void setFormat(SopremoFormat format) {
        if (format == null) {
            throw new NullPointerException("format must not be null");
        }
        if (format.getOutputFormat() == null) {
            throw new IllegalArgumentException("writing for the given format is not supported");
        }
        this.removePropertiesFrom(this.format);
        this.format = format;
        this.addPropertiesFrom(format);
    }

    public void setGlobalSortingKey(List<OrderingExpression> globalSortingKey) {
        if (globalSortingKey == null) {
            throw new NullPointerException("globalSortingKey must not be null");
        }
        this.globalSortingKey = globalSortingKey;
    }

    public void setLocalSortingKey(List<OrderingExpression> localSortingKey) {
        if (localSortingKey == null) {
            throw new NullPointerException("localSortingKey must not be null");
        }
        this.localSortingKey = localSortingKey;
    }

    public void setOutputPath(String outputPath) {
        if (outputPath == null) {
            throw new NullPointerException("outputPath must not be null");
        }
        this.outputPath = outputPath;
        this.checkPath();
    }

    public Sink withGlobalSortingKey(List<OrderingExpression> sortingKey) {
        this.setGlobalSortingKey(sortingKey);
        return this;
    }

    public Sink withLocalSortingKey(List<OrderingExpression> localSortingKey) {
        this.setLocalSortingKey(localSortingKey);
        return this;
    }

    public Sink withOutputPath(String outputPath) {
        this.setOutputPath(outputPath);
        return this;
    }

    private void checkPath() {
        try {
            URI uri = new URI(this.outputPath);
            if (uri.getScheme() == null) {
                throw new IllegalStateException("File name of source does not have a valid schema (such as hdfs or file): " + this.outputPath);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid path", e);
        }
    }
}

