/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.io;

import eu.stratosphere.api.common.io.InputFormat;
import eu.stratosphere.api.common.io.statistics.BaseStatistics;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.core.io.InputSplit;
import eu.stratosphere.sopremo.io.JsonFormat;
import eu.stratosphere.sopremo.io.SopremoFormat;
import eu.stratosphere.sopremo.operator.Property;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.util.reflect.ReflectUtil;
import java.io.IOException;
import java.net.URI;

public class SampleFormat
extends SopremoFormat {
    private final SopremoFormat originalFormat = new JsonFormat();
    public static final long DEFAULT_SAMPLE_SIZE = 10L;
    private long sampleSize = 10L;

    @Override
    public boolean canHandleFormat(URI path) {
        return this.originalFormat.canHandleFormat(path);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SampleFormat other = (SampleFormat)obj;
        return this.sampleSize == other.sampleSize && this.originalFormat.equals(other.originalFormat);
    }

    public long getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.originalFormat.hashCode();
        result = 31 * result + (int)(this.sampleSize ^ this.sampleSize >>> 32);
        return result;
    }

    @Property
    public void setSampleSize(long sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Override
    protected String[] getPreferredFilenameExtensions() {
        return this.originalFormat.getPreferredFilenameExtensions();
    }

    public static class SampleInputFormat
    extends SopremoFormat.AbstractSopremoInputFormat<InputSplit> {
        private static final long serialVersionUID = 8534362304827555826L;
        private SopremoFormat originalFormat;
        private SopremoFormat.SopremoInputFormat<InputSplit> originalInputFormat;
        private long currentSample;
        private long sampleSize;

        public void close() throws IOException {
            this.originalInputFormat.close();
        }

        @Override
        public void configure(Configuration parameters) {
            super.configure(parameters);
            this.originalInputFormat = (SopremoFormat.SopremoInputFormat)ReflectUtil.newInstance(this.originalFormat.getInputFormat());
            this.currentSample = 0L;
            Configuration originalConfiguration = new Configuration();
            SopremoUtil.transferFieldsToConfiguration(this.originalFormat, SopremoFormat.class, originalConfiguration, this.originalFormat.getInputFormat(), InputFormat.class);
            this.originalInputFormat.configure(originalConfiguration);
        }

        public InputSplit[] createInputSplits(int minNumSplits) throws IOException {
            return this.originalInputFormat.createInputSplits(minNumSplits);
        }

        public Class<? extends InputSplit> getInputSplitType() {
            return this.originalInputFormat.getInputSplitType();
        }

        public BaseStatistics getStatistics(BaseStatistics cachedStatistics) throws IOException {
            final BaseStatistics stats = this.originalInputFormat.getStatistics(cachedStatistics);
            return new BaseStatistics(){

                public float getAverageRecordWidth() {
                    return stats.getAverageRecordWidth();
                }

                public long getNumberOfRecords() {
                    return Math.min(SampleInputFormat.this.sampleSize, stats.getNumberOfRecords());
                }

                public long getTotalInputSize() {
                    return (long)Math.ceil((float)this.getNumberOfRecords() * this.getAverageRecordWidth());
                }
            };
        }

        @Override
        public IJsonNode nextValue() throws IOException {
            ++this.currentSample;
            IJsonNode value = this.originalInputFormat.nextValue();
            if (this.currentSample >= this.sampleSize || this.originalInputFormat.reachedEnd()) {
                this.endReached();
                return null;
            }
            return value;
        }

        @Override
        public void open(InputSplit split) throws IOException {
            this.originalInputFormat.open(split);
        }
    }
}

