/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.io;

import eu.stratosphere.core.fs.FSDataInputStream;
import eu.stratosphere.sopremo.io.JsonParseException;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.BigIntegerNode;
import eu.stratosphere.sopremo.type.BooleanNode;
import eu.stratosphere.sopremo.type.DecimalNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IntNode;
import eu.stratosphere.sopremo.type.LongNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.NullNode;
import eu.stratosphere.sopremo.type.ObjectNode;
import eu.stratosphere.sopremo.type.TextNode;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.chars.CharList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JsonParser {
    private final BufferedReader reader;
    private boolean reachedEnd;
    private int currentCounter;
    private boolean skipWrappingArray;
    private static char ELEMENT_SEPARATOR = (char)44;
    private static char ARRAY_START = (char)91;
    private static int STEP_SIZE = 1;
    private static String JSON_URL = "www.json.org";
    private static String ERROR_BASE = "Couldn't parse the given input: \n";
    private static String ERROR_INVALID_JSON = ERROR_BASE + "Invalid json format at position %s (visit " + JSON_URL + " for a detailed specification).\nCurrent Token: %s.\nExpected \"%s\", but was \"%s\".";
    private static String ERROR_IO = ERROR_BASE + "Couldn't access input or mark the input for reset at position %s";

    public JsonParser(FSDataInputStream stream) {
        this(new InputStreamReader((InputStream)stream, Charset.forName("utf-8")));
    }

    public JsonParser(InputStream stream) {
        this(new InputStreamReader(stream, Charset.forName("utf-8")));
    }

    public JsonParser(Reader inputStreamReader) {
        this.reader = new BufferedReader(inputStreamReader);
        this.initialize();
    }

    public JsonParser(String value) {
        this(new BufferedReader(new StringReader(value)));
    }

    public JsonParser(URL url) throws IOException {
        this(new BufferedReader(new InputStreamReader(url.openStream())));
    }

    public boolean checkEnd() {
        return this.reachedEnd;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int getNumberOfParsedChars() {
        return this.currentCounter - 1;
    }

    public IJsonNode readValueAsTree() throws JsonParseException {
        boolean firstCall;
        boolean bl = firstCall = this.currentCounter == 0;
        if (this.checkEnd() && !this.skipWrappingArray) {
            return MissingNode.getInstance();
        }
        int currentChar = this.readIgnoreWhitespace();
        if (this.checkForEOF(currentChar)) {
            return this.getRoot().createJsonNode((char)currentChar, this);
        }
        if (firstCall && this.skipWrappingArray && (char)currentChar == ARRAY_START) {
            currentChar = this.readIgnoreWhitespace();
        }
        IJsonNode result = this.parseElement(currentChar);
        this.finishCurrentParsingStep();
        return result;
    }

    public void setWrappingArraySkipping(boolean skipWrappingArray) {
        this.skipWrappingArray = skipWrappingArray;
    }

    private boolean checkForEOF(int currentChar) {
        if (currentChar == -1) {
            this.reachedEnd = true;
            return true;
        }
        return false;
    }

    private void finishCurrentParsingStep() throws JsonParseException {
        int currentChar = this.readIgnoreWhitespace();
        if (currentChar == -1) {
            this.reachedEnd = true;
        } else if ((char)currentChar != ELEMENT_SEPARATOR) {
            if (this.skipWrappingArray) {
                this.reachedEnd = true;
            } else {
                throw this.getParseException(this.getRoot().getName(), String.valueOf(ELEMENT_SEPARATOR) + " or eof", String.valueOf((char)currentChar));
            }
        }
    }

    private JsonParseException getIOException() {
        return new JsonParseException(String.format(ERROR_IO, this.getNumberOfParsedChars()));
    }

    private JsonParseException getParseException(String currentToken, String expectedValue, String currentValue) {
        return new JsonParseException(String.format(ERROR_INVALID_JSON, this.getNumberOfParsedChars() + 1, currentToken, expectedValue, currentValue));
    }

    private STATE getRoot() {
        return STATE.ROOT;
    }

    private void initialize() {
        STATE.initializeTransitions();
        this.currentCounter = 0;
        this.reachedEnd = false;
    }

    private void markReader() throws JsonParseException {
        try {
            this.reader.mark(STEP_SIZE);
        }
        catch (IOException e) {
            throw this.getIOException();
        }
    }

    private IJsonNode parseElement(int currentChar) throws JsonParseException {
        STATE nextState = this.getRoot().nextState((char)currentChar);
        if (nextState == null) {
            throw this.getParseException(this.getRoot().getName(), "one of ['{', '[', 't', 'f', 'n', 0-9, '\"', '-']", String.valueOf((char)currentChar));
        }
        return nextState.createJsonNode((char)currentChar, this);
    }

    private int read() throws JsonParseException {
        int character;
        try {
            character = this.reader.read();
        }
        catch (IOException e) {
            throw this.getIOException();
        }
        ++this.currentCounter;
        return character;
    }

    private int readIgnoreWhitespace() throws JsonParseException {
        int nextChar = this.read();
        while (Character.isWhitespace((char)nextChar) && nextChar != -1) {
            nextChar = this.read();
        }
        return nextChar;
    }

    private void resetReader() throws JsonParseException {
        try {
            this.reader.reset();
        }
        catch (IOException e) {
            throw this.getIOException();
        }
        this.currentCounter -= STEP_SIZE;
    }

    private static enum STATE {
        OBJECT{
            private final char charToFinishObject = (char)125;
            private final char keyValueSeparator = (char)58;
            private final char elementSeparator = (char)44;

            @Override
            public IJsonNode createJsonNode(char startChar, JsonParser parser) throws JsonParseException {
                int nextChar;
                boolean currentInputIsAKey = true;
                ObjectNode result = new ObjectNode();
                StringBuffer currentKey = new StringBuffer();
                while ((nextChar = parser.readIgnoreWhitespace()) != this.charToFinishObject) {
                    if (this.handleSpecialChar(nextChar, currentInputIsAKey, parser)) continue;
                    currentInputIsAKey = this.handleElement(nextChar, currentKey, parser, currentInputIsAKey, result);
                }
                if (!currentInputIsAKey) {
                    throw parser.getParseException(this.getName(), "json value expected", String.valueOf(this.charToFinishObject));
                }
                return result;
            }

            @Override
            protected String getName() {
                return "json object";
            }

            @Override
            protected void initialize() {
                this.transitions.put('{', (Object)OBJECT);
                this.transitions.put('[', (Object)ARRAY);
                this.transitions.put('t', (Object)BOOLEAN);
                this.transitions.put('f', (Object)BOOLEAN);
                this.transitions.put('n', (Object)NULL);
                this.transitions.put('-', (Object)NUMBER);
                this.transitions.put('0', (Object)NUMBER);
                this.transitions.put('1', (Object)NUMBER);
                this.transitions.put('2', (Object)NUMBER);
                this.transitions.put('3', (Object)NUMBER);
                this.transitions.put('4', (Object)NUMBER);
                this.transitions.put('5', (Object)NUMBER);
                this.transitions.put('6', (Object)NUMBER);
                this.transitions.put('7', (Object)NUMBER);
                this.transitions.put('8', (Object)NUMBER);
                this.transitions.put('9', (Object)NUMBER);
                this.transitions.put('\"', (Object)STRING);
            }

            private boolean handleElement(int nextChar, StringBuffer currentKey, JsonParser parser, boolean currentInputIsAKey, ObjectNode result) throws JsonParseException {
                STATE state = this.nextState((char)nextChar);
                if (state == null) {
                    throw parser.getParseException(this.getName(), "one of ['{', '[', 't', 'f', 'n', '-' , 0-9, '\"']", String.valueOf((char)nextChar));
                }
                IJsonNode element = state.createJsonNode((char)nextChar, parser);
                if (currentInputIsAKey) {
                    if (!(element instanceof TextNode)) {
                        throw parser.getParseException(this.getName(), "key must be a string", element.getType().toString());
                    }
                    currentKey.append((TextNode)element);
                    return false;
                }
                result.put(currentKey.toString(), element);
                currentKey.delete(0, currentKey.length());
                return true;
            }

            private boolean handleSpecialChar(int character, boolean keyNext, JsonParser parser) throws JsonParseException {
                if (character == -1) {
                    throw parser.getParseException(this.getName(), String.valueOf(this.charToFinishObject), "eof");
                }
                if ((char)character == this.elementSeparator) {
                    return true;
                }
                if ((char)character == this.keyValueSeparator) {
                    if (keyNext) {
                        throw parser.getParseException(this.getName(), "key expected", String.valueOf(this.keyValueSeparator));
                    }
                    return true;
                }
                return false;
            }
        }
        ,
        ARRAY{
            private final char charToFinishArray = (char)93;
            private final char arrayElementSeparator = (char)44;

            @Override
            public IJsonNode createJsonNode(char startChar, JsonParser parser) throws JsonParseException {
                int nextChar;
                ArrayList<IJsonNode> result = new ArrayList<IJsonNode>();
                boolean valueExpected = false;
                while ((nextChar = parser.readIgnoreWhitespace()) != this.charToFinishArray) {
                    if (this.handleSpecialChar(nextChar, parser, valueExpected, result.size())) {
                        valueExpected = true;
                        continue;
                    }
                    this.handleElement(nextChar, result, parser);
                    valueExpected = false;
                }
                if (valueExpected) {
                    throw parser.getParseException(this.getName(), "json value", String.valueOf(this.charToFinishArray));
                }
                return ArrayNode.valueOf(result.iterator());
            }

            @Override
            protected String getName() {
                return "json array";
            }

            @Override
            protected void initialize() {
                this.transitions.put('{', (Object)OBJECT);
                this.transitions.put('[', (Object)ARRAY);
                this.transitions.put('t', (Object)BOOLEAN);
                this.transitions.put('f', (Object)BOOLEAN);
                this.transitions.put('n', (Object)NULL);
                this.transitions.put('-', (Object)NUMBER);
                this.transitions.put('0', (Object)NUMBER);
                this.transitions.put('1', (Object)NUMBER);
                this.transitions.put('2', (Object)NUMBER);
                this.transitions.put('3', (Object)NUMBER);
                this.transitions.put('4', (Object)NUMBER);
                this.transitions.put('5', (Object)NUMBER);
                this.transitions.put('6', (Object)NUMBER);
                this.transitions.put('7', (Object)NUMBER);
                this.transitions.put('8', (Object)NUMBER);
                this.transitions.put('9', (Object)NUMBER);
                this.transitions.put('\"', (Object)STRING);
            }

            private void handleElement(int nextChar, List<IJsonNode> result, JsonParser parser) throws JsonParseException {
                STATE state = this.nextState((char)nextChar);
                if (state == null) {
                    throw parser.getParseException(this.getName(), "one of ['{', '[', 't', 'f', 'n', '-' , 0-9, '\"']", String.valueOf((char)nextChar));
                }
                IJsonNode element = state.createJsonNode((char)nextChar, parser);
                result.add(element);
            }

            private boolean handleSpecialChar(int nextChar, JsonParser parser, boolean valueExpected, int currentResultSize) throws JsonParseException {
                if (nextChar == -1) {
                    throw parser.getParseException(this.getName(), String.valueOf(this.charToFinishArray), "eof");
                }
                if ((char)nextChar == this.arrayElementSeparator) {
                    if (currentResultSize == 0 || valueExpected) {
                        throw parser.getParseException(this.getName(), "json value", String.valueOf(this.arrayElementSeparator));
                    }
                    return true;
                }
                return false;
            }
        }
        ,
        STRING{
            private final char charToFinishString = (char)34;

            @Override
            public IJsonNode createJsonNode(char startChar, JsonParser parser) throws JsonParseException {
                StringBuffer buffer = new StringBuffer();
                char nextChar = (char)parser.read();
                while (nextChar != this.charToFinishString) {
                    if (nextChar == '\\') {
                        buffer.append(this.unescape(parser));
                    } else {
                        buffer.append(nextChar);
                    }
                    nextChar = (char)parser.read();
                }
                return TextNode.valueOf(buffer.toString());
            }

            @Override
            protected String getName() {
                return "string value";
            }

            private char unescape(JsonParser parser) throws JsonParseException {
                char escapeChar = (char)parser.read();
                switch (escapeChar) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        return escapeChar;
                    }
                    case 'b': {
                        return '\b';
                    }
                    case 'f': {
                        return '\f';
                    }
                    case 'n': {
                        return '\n';
                    }
                    case 'r': {
                        return '\r';
                    }
                    case 't': {
                        return '\t';
                    }
                    case 'u': {
                        char[] hexCode = new char[]{(char)parser.read(), (char)parser.read(), (char)parser.read(), (char)parser.read()};
                        return (char)Integer.parseInt(String.valueOf(hexCode), ARRAY_START);
                    }
                }
                throw parser.getParseException(this.getName(), "a valid escape sequence \\(\" | \\ | / | b | f | n | r | t | uXXXX)", String.valueOf("\\" + escapeChar));
            }
        }
        ,
        BOOLEAN{
            private final char expectedCharTrue = (char)116;
            private final char[] trueChars = new char[]{'r', 'u', 'e'};
            private final char expectedCharFalse = (char)102;
            private final char[] falseChars = new char[]{'a', 'l', 's', 'e'};

            @Override
            public IJsonNode createJsonNode(char startChar, JsonParser parser) throws JsonParseException {
                BooleanNode result;
                char[] expectedContentWithoutFirstChar;
                if (startChar == this.expectedCharTrue) {
                    expectedContentWithoutFirstChar = this.trueChars;
                    result = BooleanNode.TRUE;
                } else if (startChar == this.expectedCharFalse) {
                    expectedContentWithoutFirstChar = this.falseChars;
                    result = BooleanNode.FALSE;
                } else {
                    throw parser.getParseException(this.getName(), "one of [" + this.expectedCharTrue + ", " + this.expectedCharFalse + "]", String.valueOf(startChar));
                }
                STATE.compareWithReaderContent(expectedContentWithoutFirstChar, parser, (STATE)this);
                return result;
            }

            @Override
            protected String getName() {
                return "boolean value";
            }
        }
        ,
        NUMBER{
            private final CharList allowedCharactersInNumbers = new CharArrayList(Arrays.asList(Character.valueOf('-'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('.'), Character.valueOf('e'), Character.valueOf('E'), Character.valueOf('+')));
            private final String numberRegex = "^[-]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$";

            @Override
            public IJsonNode createJsonNode(char startChar, JsonParser parser) throws JsonParseException {
                char nextChar;
                StringBuffer buffer = new StringBuffer().append(startChar);
                parser.markReader();
                while (this.allowedCharactersInNumbers.contains(nextChar = (char)parser.read())) {
                    parser.markReader();
                    buffer.append(nextChar);
                }
                parser.resetReader();
                IJsonNode number = this.parseNumber(buffer.toString());
                if (number == null) {
                    throw parser.getParseException(this.getName(), "a numerical value", buffer.toString());
                }
                return number;
            }

            @Override
            protected String getName() {
                return "numerical value";
            }

            private IJsonNode parseNumber(String value) {
                if (value.matches(this.numberRegex)) {
                    BigDecimal bigDec = new BigDecimal(value);
                    if (bigDec.scale() == 0) {
                        BigInteger bigInt = bigDec.unscaledValue();
                        if (bigInt.bitLength() <= 31) {
                            return IntNode.valueOf(bigInt.intValue());
                        }
                        if (bigInt.bitLength() <= 63) {
                            return LongNode.valueOf(bigInt.longValue());
                        }
                        return BigIntegerNode.valueOf(bigInt);
                    }
                    return DecimalNode.valueOf(bigDec);
                }
                return null;
            }
        }
        ,
        NULL{
            private final char expectedStartChar = (char)110;
            private final char[] nullWithoutFirstChar = new char[]{'u', 'l', 'l'};

            @Override
            public IJsonNode createJsonNode(char startChar, JsonParser parser) throws JsonParseException {
                if (startChar != this.expectedStartChar) {
                    throw parser.getParseException(this.getName(), String.valueOf(this.expectedStartChar), String.valueOf(startChar));
                }
                STATE.compareWithReaderContent(this.nullWithoutFirstChar, parser, (STATE)this);
                return NullNode.getInstance();
            }

            @Override
            protected String getName() {
                return "null value";
            }
        }
        ,
        ROOT{

            @Override
            public IJsonNode createJsonNode(char startChar, JsonParser parser) throws JsonParseException {
                return MissingNode.getInstance();
            }

            @Override
            protected String getName() {
                return "root element";
            }

            @Override
            protected void initialize() {
                this.transitions.put('{', (Object)OBJECT);
                this.transitions.put('[', (Object)ARRAY);
                this.transitions.put('t', (Object)BOOLEAN);
                this.transitions.put('f', (Object)BOOLEAN);
                this.transitions.put('n', (Object)NULL);
                this.transitions.put('-', (Object)NUMBER);
                this.transitions.put('0', (Object)NUMBER);
                this.transitions.put('1', (Object)NUMBER);
                this.transitions.put('2', (Object)NUMBER);
                this.transitions.put('3', (Object)NUMBER);
                this.transitions.put('4', (Object)NUMBER);
                this.transitions.put('5', (Object)NUMBER);
                this.transitions.put('6', (Object)NUMBER);
                this.transitions.put('7', (Object)NUMBER);
                this.transitions.put('8', (Object)NUMBER);
                this.transitions.put('9', (Object)NUMBER);
                this.transitions.put('\"', (Object)STRING);
            }
        };

        protected Char2ObjectMap<STATE> transitions = new Char2ObjectOpenHashMap();

        public abstract IJsonNode createJsonNode(char var1, JsonParser var2) throws JsonParseException;

        public STATE nextState(char character) {
            if (this.transitions.containsKey(character)) {
                return (STATE)((Object)this.transitions.get(character));
            }
            return null;
        }

        protected abstract String getName();

        protected void initialize() {
        }

        public static void initializeTransitions() {
            for (STATE state : STATE.values()) {
                state.initialize();
            }
        }

        private static boolean compareWithReaderContent(char[] expected, JsonParser parser, STATE currentState) throws JsonParseException {
            for (char c : expected) {
                char currentChar = (char)parser.read();
                if (c == currentChar) continue;
                throw parser.getParseException(currentState.getName(), String.valueOf(c), String.valueOf(currentChar));
            }
            return true;
        }
    }
}

