/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.io;

import eu.stratosphere.sopremo.io.JsonToken;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.IStreamNode;
import eu.stratosphere.sopremo.type.NullNode;
import eu.stratosphere.sopremo.type.TextNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.IdentityHashMap;
import java.util.Map;

public class JsonGenerator {
    BufferedWriter writer;
    boolean isFirst = true;

    public JsonGenerator(File file) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(file));
    }

    public JsonGenerator(OutputStream stream) {
        this.writer = new BufferedWriter(new OutputStreamWriter(stream));
    }

    public JsonGenerator(Writer writer) {
        this.writer = new BufferedWriter(writer);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void writeEndArray() throws IOException {
        JsonToken.END_ARRAY.write(this.writer);
        this.writer.flush();
    }

    public void writeStartArray() throws IOException {
        JsonToken.START_ARRAY.write(this.writer);
        this.writer.flush();
    }

    public void writeTree(IJsonNode iJsonNode) throws IOException {
        if (iJsonNode != null) {
            if (!this.isFirst) {
                this.writer.write(",\n");
            }
            JsonTypeWriter<IJsonNode> typeWriter = JsonTypeWriterPool.getJsonTypeWriterFor(iJsonNode);
            typeWriter.write(iJsonNode, this.writer);
            this.isFirst = false;
        }
    }

    private static class TextNodeTypeWriter
    implements JsonTypeWriter<TextNode> {
        private static TextNodeTypeWriter Instance = new TextNodeTypeWriter();

        private TextNodeTypeWriter() {
        }

        @Override
        public void write(TextNode node, Writer writer) throws IOException {
            writer.append('\"');
            TextNode textValue = node;
            int count = textValue.length();
            for (int index = 0; index < count; ++index) {
                char ch = textValue.charAt(index);
                if (ch == '\"') {
                    writer.append("\\\"");
                    continue;
                }
                writer.append(ch);
            }
            writer.append('\"');
        }
    }

    private static class ObjectNodeTypeWriter
    implements JsonTypeWriter<IObjectNode> {
        private static ObjectNodeTypeWriter Instance = new ObjectNodeTypeWriter();

        private ObjectNodeTypeWriter() {
        }

        @Override
        public void write(IObjectNode node, Writer writer) throws IOException {
            writer.append('{');
            boolean first = true;
            for (Map.Entry<String, IJsonNode> en : node) {
                if (first) {
                    first = false;
                } else {
                    writer.append(',');
                }
                writer.append('\"').append(en.getKey()).append("\":");
                JsonTypeWriterPool.getJsonTypeWriterFor(en.getValue()).write(en.getValue(), writer);
            }
            writer.append('}');
        }
    }

    private static class NullNodeTypeWriter
    implements JsonTypeWriter<NullNode> {
        private static NullNodeTypeWriter Instance = new NullNodeTypeWriter();

        private NullNodeTypeWriter() {
        }

        @Override
        public void write(NullNode node, Writer writer) throws IOException {
            writer.append("null");
        }
    }

    private static class JsonTypeWriterPool {
        private static Map<Class<? extends IJsonNode>, JsonTypeWriter<IJsonNode>> writerMap = new IdentityHashMap<Class<? extends IJsonNode>, JsonTypeWriter<IJsonNode>>(4);

        private JsonTypeWriterPool() {
        }

        public static JsonTypeWriter<IJsonNode> getJsonTypeWriterFor(IJsonNode aJsonNode) {
            GenericNodeTypeWriter writerToReturn = writerMap.get(aJsonNode.getType());
            if (writerToReturn == null) {
                writerToReturn = GenericNodeTypeWriter.Instance;
            }
            return writerToReturn;
        }

        static {
            writerMap.put(TextNode.class, TextNodeTypeWriter.Instance);
            writerMap.put(IObjectNode.class, ObjectNodeTypeWriter.Instance);
            writerMap.put(IStreamNode.class, ArrayNodeTypeWriter.Instance);
            writerMap.put(IArrayNode.class, ArrayNodeTypeWriter.Instance);
            writerMap.put(NullNode.class, NullNodeTypeWriter.Instance);
        }
    }

    private static interface JsonTypeWriter<T extends IJsonNode> {
        public void write(T var1, Writer var2) throws IOException;
    }

    private static class GenericNodeTypeWriter<T extends IJsonNode>
    implements JsonTypeWriter<IJsonNode> {
        private static GenericNodeTypeWriter<IJsonNode> Instance = new GenericNodeTypeWriter();

        private GenericNodeTypeWriter() {
        }

        @Override
        public void write(IJsonNode node, Writer writer) throws IOException {
            node.appendAsString(writer);
        }
    }

    private static class ArrayNodeTypeWriter
    implements JsonTypeWriter<IStreamNode<?>> {
        private static ArrayNodeTypeWriter Instance = new ArrayNodeTypeWriter();

        private ArrayNodeTypeWriter() {
        }

        @Override
        public void write(IStreamNode<?> node, Writer writer) throws IOException {
            writer.append('[');
            boolean first = true;
            for (IJsonNode elem : node) {
                if (first) {
                    first = false;
                } else {
                    writer.append(',');
                }
                JsonTypeWriterPool.getJsonTypeWriterFor(elem).write(elem, writer);
            }
            writer.append(']');
        }
    }
}

