/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.io;

import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.statistics.BaseStatistics;
import eu.stratosphere.core.fs.BlockLocation;
import eu.stratosphere.core.fs.FSDataInputStream;
import eu.stratosphere.core.fs.FSDataOutputStream;
import eu.stratosphere.core.fs.FileInputSplit;
import eu.stratosphere.core.fs.FileStatus;
import eu.stratosphere.core.fs.FileSystem;
import eu.stratosphere.core.fs.Path;
import eu.stratosphere.sopremo.io.JsonGenerator;
import eu.stratosphere.sopremo.io.JsonParser;
import eu.stratosphere.sopremo.io.SopremoFormat;
import eu.stratosphere.sopremo.operator.Name;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

@Name(noun={"json"})
public class JsonFormat
extends SopremoFormat {
    @Override
    protected String[] getPreferredFilenameExtensions() {
        return new String[]{"json"};
    }

    public static class JsonOutputFormat
    extends SopremoFormat.SopremoFileOutputFormat {
        private static final long serialVersionUID = -1775609830466072732L;
        private JsonGenerator generator;

        public void close() throws IOException {
            this.generator.writeEndArray();
            this.generator.close();
            super.close();
        }

        @Override
        public void writeValue(IJsonNode value) throws IOException {
            this.generator.writeTree(value);
        }

        @Override
        protected void open(FSDataOutputStream stream, int taskNumber) throws IOException {
            this.generator = new JsonGenerator(new OutputStreamWriter((OutputStream)stream, this.getEncoding()));
            this.generator.writeStartArray();
        }
    }

    public static class JsonInputFormat
    extends SopremoFormat.SopremoFileInputFormat {
        private static final long serialVersionUID = -642104267156446471L;
        private JsonParser parser;

        public void close() throws IOException {
            super.close();
            this.parser.close();
        }

        public FileInputSplit[] createInputSplits(int minNumSplits) throws IOException {
            Path path = this.filePath;
            FileSystem fs = path.getFileSystem();
            FileStatus pathFile = fs.getFileStatus(path);
            if (pathFile.isDir()) {
                FileStatus[] files = fs.listStatus(path);
                FileInputSplit[] splits = new FileInputSplit[files.length];
                for (int index = 0; index < splits.length; ++index) {
                    FileStatus fileStatus = files[index];
                    long len = fileStatus.getLen();
                    BlockLocation[] blocks = fs.getFileBlockLocations(fileStatus, 0L, len);
                    splits[index] = new FileInputSplit(index, fileStatus.getPath(), 0L, len, this.getHosts(blocks));
                }
                return splits;
            }
            BlockLocation[] blocks = fs.getFileBlockLocations(pathFile, 0L, pathFile.getLen());
            return new FileInputSplit[]{new FileInputSplit(0, pathFile.getPath(), 0L, pathFile.getLen(), this.getHosts(blocks))};
        }

        @Override
        public FileInputFormat.FileBaseStatistics getStatistics(BaseStatistics cachedStatistics) {
            return null;
        }

        @Override
        public IJsonNode nextValue() throws IOException {
            IJsonNode value = this.parser.readValueAsTree();
            if (this.parser.checkEnd()) {
                this.endReached();
            }
            return value;
        }

        protected String[] getHosts(BlockLocation[] blocks) throws IOException {
            return blocks.length > 0 ? blocks[0].getHosts() : new String[]{};
        }

        @Override
        protected void open(FSDataInputStream stream, FileInputSplit split) {
            if (split.getStart() != 0L) {
                this.endReached();
                return;
            }
            try {
                this.parser = new JsonParser(new InputStreamReader((InputStream)stream, this.getEncoding()));
                this.parser.setWrappingArraySkipping(true);
                if (this.parser.checkEnd()) {
                    this.endReached();
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }
}

