/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.io;

import eu.stratosphere.api.common.io.GenericInputFormat;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.core.io.GenericInputSplit;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.io.GeneratorInputSplit;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.serialization.SopremoRecord;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.NullNode;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;

public class GeneratorInputFormat
extends GenericInputFormat<SopremoRecord> {
    private static final long serialVersionUID = -353023811572404812L;
    public static final String ADHOC_EXPRESSION_PARAMETER_KEY = "sopremo.source.generator.expression";
    private Iterator<IJsonNode> valueIterator;
    private int numValues = 1;

    public void close() throws IOException {
    }

    public void configure(Configuration parameters) {
        super.configure(parameters);
        EvaluationExpression expression = SopremoUtil.getObject(parameters, ADHOC_EXPRESSION_PARAMETER_KEY, null);
        IJsonNode value = expression.evaluate(NullNode.getInstance());
        if (value instanceof ArrayNode) {
            this.numValues = ((ArrayNode)value).size();
            this.valueIterator = ((IArrayNode)value).iterator();
        } else {
            this.valueIterator = Collections.singleton(value).iterator();
        }
    }

    public GeneratorInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        int numInputSplits = Math.min(minNumSplits, this.numValues);
        GeneratorInputSplit[] inputSplits = new GeneratorInputSplit[numInputSplits];
        int start = 0;
        for (int i = 0; i < numInputSplits; ++i) {
            int end = (i + 1) * this.numValues / numInputSplits;
            inputSplits[i] = new GeneratorInputSplit(i, start, end);
            start = end;
        }
        return inputSplits;
    }

    public Class<GeneratorInputSplit> getInputSplitType() {
        return GeneratorInputSplit.class;
    }

    public boolean nextRecord(SopremoRecord record) throws IOException {
        if (this.reachedEnd()) {
            throw new IOException("End of input split is reached");
        }
        IJsonNode value = this.valueIterator.next();
        record.setNode(value);
        return true;
    }

    public void open(GenericInputSplit split) throws IOException {
        super.open(split);
        if (split == null || !(split instanceof GeneratorInputSplit)) {
            throw new IOException("Invalid InputSplit: " + split);
        }
    }

    public boolean reachedEnd() throws IOException {
        return !this.valueIterator.hasNext();
    }
}

