/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.io;

import com.google.common.collect.Lists;
import eu.stratosphere.api.common.operators.GenericDataSource;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.core.fs.FSDataInputStream;
import eu.stratosphere.core.fs.FSDataOutputStream;
import eu.stratosphere.core.fs.FileInputSplit;
import eu.stratosphere.core.fs.FileStatus;
import eu.stratosphere.core.fs.FileSystem;
import eu.stratosphere.core.fs.Path;
import eu.stratosphere.runtime.fs.LineReader;
import eu.stratosphere.sopremo.io.SopremoFormat;
import eu.stratosphere.sopremo.operator.Name;
import eu.stratosphere.sopremo.operator.Property;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.ObjectNode;
import eu.stratosphere.sopremo.type.TextNode;
import eu.stratosphere.util.Equaler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;

@Name(noun={"csv", "tsv"})
public class CsvFormat
extends SopremoFormat {
    public static final int DEFAULT_NUM_SAMPLES = 10;
    public static final char AUTO = '\u0000';
    private char fieldDelimiter = '\u0000';
    private Boolean quotation;
    private String[] keyNames = new String[0];
    private int numLineSamples = 10;

    @Override
    public void configureForInput(Configuration configuration, GenericDataSource<?> source, String inputPath) {
        this.configureDelimiter(inputPath);
        super.configureForInput(configuration, source, inputPath);
    }

    @Override
    public void configureForOutput(Configuration configuration, String outputPath) {
        this.configureDelimiter(outputPath);
        super.configureForOutput(configuration, outputPath);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CsvFormat other = (CsvFormat)obj;
        return this.fieldDelimiter == other.fieldDelimiter && this.numLineSamples == other.numLineSamples && Equaler.SafeEquals.equal((Object)this.quotation, (Object)other.quotation) && Arrays.equals(this.keyNames, other.keyNames);
    }

    public String getFieldDelimiter() {
        return String.valueOf(this.fieldDelimiter);
    }

    public String[] getKeyNames() {
        return this.keyNames;
    }

    public int getNumLineSamples() {
        return this.numLineSamples;
    }

    public Boolean getQuotation() {
        return this.quotation;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.fieldDelimiter;
        result = 31 * result + Arrays.hashCode(this.keyNames);
        result = 31 * result + this.numLineSamples;
        result = 31 * result + (this.quotation == null ? 0 : this.quotation.hashCode());
        return result;
    }

    @Property
    @Name(noun={"delimiter"})
    public void setFieldDelimiter(String fieldDelimiter) {
        if (fieldDelimiter.length() != 1) {
            throw new IllegalArgumentException("field delimiter needs to be exactly one character");
        }
        this.fieldDelimiter = fieldDelimiter.charAt(0);
    }

    @Property
    @Name(noun={"columns"})
    public void setKeyNames(String ... keyNames) {
        if (keyNames == null) {
            throw new NullPointerException("keyNames must not be null");
        }
        this.keyNames = keyNames;
    }

    public void setNumLineSamples(int numLineSamples) {
        if (numLineSamples <= 0) {
            throw new IllegalArgumentException("numLineSamples must be positive");
        }
        this.numLineSamples = numLineSamples;
    }

    @Property
    @Name(verb={"quote"})
    public void setQuotation(Boolean quotation) {
        this.quotation = quotation;
    }

    public CsvFormat withFieldDelimiter(String fieldDelimiter) {
        this.setFieldDelimiter(fieldDelimiter);
        return this;
    }

    public CsvFormat withKeyNames(String ... keyNames) {
        this.setKeyNames(keyNames);
        return this;
    }

    public CsvFormat withQuotation(Boolean quotation) {
        this.setQuotation(quotation);
        return this;
    }

    @Override
    protected String[] getPreferredFilenameExtensions() {
        return new String[]{"csv", "tsv"};
    }

    private void configureDelimiter(String outputPath) {
        if (this.fieldDelimiter == '\u0000') {
            try {
                this.fieldDelimiter = (char)(new URI(outputPath).getPath().endsWith(".tsv") ? 9 : 44);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    static char inferFieldDelimiter(Path path) {
        return path.getName().endsWith("tsv") ? (char)'\t' : ',';
    }

    private static enum State {
        TOP_LEVEL,
        QUOTED,
        ESCAPED,
        UNICODE;

    }

    public static class CsvOutputFormat
    extends SopremoFormat.SopremoFileOutputFormat {
        private static final long serialVersionUID = 385038405770899069L;
        private char fieldDelimiter;
        private String[] keyNames;
        private Boolean quotation;
        private Writer writer;
        private transient IntList escapePositions = new IntArrayList();

        public void close() throws IOException {
            this.writer.close();
            super.close();
        }

        @Override
        public void writeValue(IJsonNode value) throws IOException {
            if (this.keyNames.length == 0) {
                if (value instanceof IArrayNode) {
                    this.writeArray(value);
                    return;
                }
                if (!(value instanceof IObjectNode)) {
                    this.write(value);
                    this.writeLineTerminator();
                    return;
                }
                this.detectKeyNames(value);
            }
            this.writeObject((IObjectNode)value);
        }

        protected void detectKeyNames(IJsonNode value) {
            ArrayList values = Lists.newArrayList(((IObjectNode)value).iterator());
            this.keyNames = new String[values.size()];
            for (int index = 0; index < this.keyNames.length; ++index) {
                this.keyNames[index] = (String)((Map.Entry)values.get(index)).getKey();
            }
            if (this.keyNames.length == 0) {
                throw new IllegalStateException("Found empty object and cannot detect key names");
            }
        }

        protected String escapeString(String string) {
            this.escapePositions.clear();
            int count = string.length();
            for (int index = 0; index < count; ++index) {
                char ch = string.charAt(index);
                if (ch != '\"' && ch != '\\') continue;
                this.escapePositions.add(index);
            }
            if (this.escapePositions.size() > 0) {
                char[] source = string.toCharArray();
                char[] result = new char[string.length() + this.escapePositions.size()];
                int srcPos = 0;
                int size = this.escapePositions.size();
                for (int index = 0; index < size; ++index) {
                    int endPos = this.escapePositions.getInt(index);
                    int length = endPos - srcPos;
                    int targetPos = srcPos + index;
                    System.arraycopy(source, srcPos, result, targetPos, length);
                    srcPos = endPos;
                    result[targetPos + length] = 92;
                }
                System.arraycopy(source, srcPos, result, srcPos + this.escapePositions.size(), source.length - srcPos);
                string = new String(result);
            }
            return string;
        }

        @Override
        protected void open(FSDataOutputStream stream, int taskNumber) throws IOException {
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, this.getEncoding()));
        }

        private void write(IJsonNode node) throws IOException {
            String string = node.toString();
            if (this.quotation != Boolean.FALSE) {
                this.writer.write(34);
                this.writer.write(this.escapeString(string));
                this.writer.write(34);
            } else {
                this.writer.write(string);
            }
        }

        private void writeArray(IJsonNode value) throws IOException {
            IArrayNode array = (IArrayNode)value;
            if (!array.isEmpty()) {
                this.write((IJsonNode)array.get(0));
                for (int index = 1; index < array.size(); ++index) {
                    this.writeSeparator();
                    this.write((IJsonNode)array.get(index));
                }
            }
            this.writeLineTerminator();
        }

        private void writeLineTerminator() throws IOException {
            this.writer.write(10);
        }

        private void writeObject(IObjectNode value) throws IOException {
            this.write((IJsonNode)value.get(this.keyNames[0]));
            for (int index = 1; index < this.keyNames.length; ++index) {
                this.writeSeparator();
                this.write((IJsonNode)value.get(this.keyNames[index]));
            }
            this.writeLineTerminator();
        }

        private void writeSeparator() throws IOException {
            this.writer.write(this.fieldDelimiter);
        }
    }

    public static class CsvInputFormat
    extends SopremoFormat.SopremoFileInputFormat {
        private static final long serialVersionUID = -4999295498719746952L;
        private char fieldDelimiter;
        private Boolean quotation;
        private boolean usesQuotation;
        private String[] keyNames;
        private int numLineSamples;
        private final Deque<State> state = new LinkedList<State>();
        private CountingReader reader;
        private final IObjectNode objectNode = new ObjectNode();
        private final StringBuilder builder = new StringBuilder();
        private char unicodeChar;
        private char unicodeCount;
        private long pos = 0L;

        public void close() throws IOException {
            this.revertToPreviousState();
            this.reader.close();
            super.close();
        }

        @Override
        public IJsonNode nextValue() throws IOException {
            int lastCharacter;
            int fieldIndex = 0;
            boolean lastValue = false;
            this.objectNode.clear();
            do {
                if ((lastCharacter = this.fillBuilderWithNextField()) == -1 && !lastValue) {
                    if (this.builder.length() == 0 && fieldIndex == 0) break;
                    lastValue = true;
                    this.reader.liftLimit();
                    lastCharacter = 0;
                    continue;
                }
                this.addToObject(fieldIndex++, this.builder.toString());
                this.builder.setLength(0);
            } while (lastCharacter != 10 && lastCharacter != -1);
            if (lastCharacter == -1 || lastValue) {
                this.endReached();
            }
            if (this.objectNode.size() == 0) {
                return null;
            }
            return this.objectNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected float getAverageRecordBytes(FileSystem fs, ArrayList<FileStatus> files, long fileSize) throws IOException {
            int numSamples = Math.min(this.numLineSamples, (int)(fileSize / 1024L));
            if (numSamples < 2) {
                numSamples = 2;
            }
            long offset = 0L;
            long bytes = 0L;
            long stepSize = fileSize / (long)numSamples;
            int fileNum = 0;
            int samplesTaken = 0;
            for (int sampleNum = 0; sampleNum < numSamples && fileNum < files.size(); ++sampleNum) {
                FileStatus currentFile = files.get(fileNum);
                FSDataInputStream inStream = null;
                try {
                    inStream = fs.open(currentFile.getPath());
                    LineReader lineReader = new LineReader(inStream, offset, currentFile.getLen() - offset, 1024);
                    byte[] line = lineReader.readLine();
                    lineReader.close();
                    if (line != null && line.length > 0) {
                        ++samplesTaken;
                        bytes += (long)(line.length + 1);
                    }
                }
                finally {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                offset += stepSize;
                while (fileNum < files.size() && offset >= (currentFile = files.get(fileNum)).getLen()) {
                    offset -= currentFile.getLen();
                    ++fileNum;
                }
            }
            return (float)bytes / (float)samplesTaken;
        }

        @Override
        protected void open(FSDataInputStream stream, FileInputSplit split) throws IOException {
            this.setState(State.TOP_LEVEL);
            this.reader = new CountingReader(stream, this.getEncoding(), split.getStart() + split.getLength());
            boolean bl = this.usesQuotation = this.quotation == Boolean.TRUE;
            if (this.quotation == null) {
                int ch;
                for (int index = 0; !this.usesQuotation && index < 1000 && (ch = this.reader.read()) != -1; ++index) {
                    this.usesQuotation = ch == 34;
                }
                this.reader.seek(this.splitStart);
            }
            if (this.keyNames.length == 0) {
                if (split.getSplitNumber() > 0) {
                    this.reader.seek(0L);
                }
                this.pos = 0L;
                this.keyNames = this.extractKeyNames();
            }
            if (this.splitStart > 0L) {
                int ch;
                this.pos = this.splitStart - 1L;
                this.reader.seek(this.pos);
                if (this.usesQuotation) {
                    while ((ch = this.reader.read()) != -1 && ch != 10) {
                        ++this.pos;
                    }
                    if (ch == -1) {
                        this.endReached();
                    }
                } else {
                    while ((ch = this.reader.read()) != -1 && ch != 10) {
                        ++this.pos;
                    }
                    if (ch == -1) {
                        this.endReached();
                    }
                }
            }
        }

        private void addToObject(int fieldIndex, String string) {
            if (fieldIndex < this.keyNames.length) {
                this.objectNode.put(this.keyNames[fieldIndex], TextNode.valueOf(string));
            }
        }

        private String[] extractKeyNames() throws IOException {
            int lastCharacter;
            ArrayList<String> keyNames = new ArrayList<String>();
            do {
                lastCharacter = this.fillBuilderWithNextField();
                keyNames.add(this.builder.toString());
                this.builder.setLength(0);
            } while (lastCharacter != -1 && lastCharacter != 10);
            return keyNames.toArray(new String[keyNames.size()]);
        }

        /*
         * Enabled aggressive block sorting
         */
        private int fillBuilderWithNextField() throws IOException {
            int character = 0;
            while ((character = this.reader.read()) != -1) {
                char ch = (char)character;
                block0 : switch (this.getCurrentState()) {
                    case TOP_LEVEL: {
                        if (ch == this.fieldDelimiter) {
                            this.builder.toString();
                            return character;
                        }
                        if (ch == '\n') {
                            int lastCharPos = this.builder.length() - 1;
                            if (lastCharPos < 0) return character;
                            if (this.builder.charAt(lastCharPos) != '\r') return character;
                            this.builder.setLength(lastCharPos);
                            return character;
                        }
                        if (this.usesQuotation && ch == '\"') {
                            this.setState(State.QUOTED);
                            break;
                        }
                        this.builder.append(ch);
                        break;
                    }
                    case ESCAPED: {
                        if (ch == 'u') {
                            this.setState(State.UNICODE);
                            break;
                        }
                        this.builder.append(ch);
                        this.revertToPreviousState();
                        break;
                    }
                    case QUOTED: {
                        switch (ch) {
                            case '\"': {
                                this.revertToPreviousState();
                                break block0;
                            }
                            case '\\': {
                                this.setState(State.ESCAPED);
                                break block0;
                            }
                        }
                        this.builder.append(ch);
                        break;
                    }
                    case UNICODE: {
                        int digit = Character.digit(ch, 16);
                        if (digit == -1) throw new IOException("Cannot parse unicode character at position: " + this.pos + " split start: " + this.splitStart);
                        this.unicodeChar = (char)(this.unicodeChar << 4 | digit);
                        this.unicodeCount = (char)(this.unicodeCount + '\u0001');
                        if (this.unicodeCount < '\u0004') break;
                        this.builder.append(this.unicodeChar);
                        this.unicodeChar = '\u0000';
                        this.unicodeCount = '\u0000';
                        this.revertToPreviousState();
                        this.revertToPreviousState();
                    }
                }
                ++this.pos;
            }
            return character;
        }

        private State getCurrentState() {
            return this.state.peek();
        }

        private State revertToPreviousState() {
            return this.state.pop();
        }

        private void setState(State newState) {
            this.state.push(newState);
        }
    }

    public static class CountingReader
    extends Reader {
        private long absolutePos = 0L;
        private long limit = 0L;
        private boolean reachedLimit = false;
        private boolean eos = false;
        private final ByteBuffer streamBuffer = ByteBuffer.allocate(100);
        private final CharBuffer charBuffer = CharBuffer.allocate(100);
        private final FSDataInputStream stream;
        private CharsetDecoder decoder;
        private final Charset cs;

        public CountingReader(FSDataInputStream stream, String charset, long limit) {
            this.stream = stream;
            this.cs = Charset.forName(charset);
            this.decoder = this.cs.newDecoder();
            this.limit = limit;
            this.charBuffer.limit(0);
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        public void liftLimit() {
            this.limit = Long.MAX_VALUE;
            this.eos = false;
            this.reachedLimit = false;
        }

        public boolean reachedLimit() {
            return this.reachedLimit;
        }

        @Override
        public int read() throws IOException {
            if (this.charBuffer.remaining() == 0) {
                if (!this.eos) {
                    this.fillCharBufferIfEmpty();
                }
                if (this.eos) {
                    return -1;
                }
            }
            return this.charBuffer.get();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int toRead;
            int currentReadCount;
            for (toRead = len - off; toRead > 0; toRead -= currentReadCount) {
                this.fillCharBufferIfEmpty();
                currentReadCount = Math.min(toRead, this.charBuffer.length());
                this.charBuffer.get(cbuf, off, currentReadCount);
            }
            return len - toRead;
        }

        public void seek(long absolutePos) throws IOException {
            this.absolutePos = absolutePos;
            this.stream.seek(absolutePos);
            this.charBuffer.limit(0);
            this.streamBuffer.clear();
            this.eos = false;
            this.reachedLimit = false;
            this.decoder = this.cs.newDecoder();
        }

        private void fillCharBufferIfEmpty() throws IOException {
            int undecodedBytes;
            int maxLen = this.streamBuffer.capacity();
            int position = this.streamBuffer.position();
            byte[] array = this.streamBuffer.array();
            int read = this.stream.read(array, position, (int)Math.min((long)(maxLen - position), this.limit - this.absolutePos));
            if (read <= 0) {
                this.eos = true;
                this.reachedLimit = true;
                return;
            }
            this.absolutePos += (long)read;
            this.streamBuffer.position(0);
            this.streamBuffer.limit(position + read);
            this.reachedLimit = this.limit <= this.absolutePos;
            this.charBuffer.clear();
            CoderResult coderResult = this.decoder.decode(this.streamBuffer, this.charBuffer, this.eos);
            this.charBuffer.flip();
            if (coderResult == CoderResult.UNDERFLOW && !this.eos && (undecodedBytes = this.streamBuffer.remaining()) > 0) {
                System.arraycopy(array, maxLen - undecodedBytes, array, 0, undecodedBytes);
                this.streamBuffer.limit(maxLen);
                this.streamBuffer.position(undecodedBytes);
                this.absolutePos -= (long)undecodedBytes;
            } else {
                this.streamBuffer.clear();
            }
        }
    }
}

