/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.function;

import eu.stratosphere.sopremo.function.SopremoFunction;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;

public class SopremoFunctionWithDefaultParameters
extends SopremoFunction {
    private final IArrayNode<IJsonNode> defaultParameters = new ArrayNode<IJsonNode>();
    private final SopremoFunction originalFunction;

    public SopremoFunctionWithDefaultParameters(SopremoFunction originalFunction, int minimumNumberOfParameters) {
        super(minimumNumberOfParameters, originalFunction.getMaximumNumberOfParameters());
        this.originalFunction = originalFunction;
    }

    public SopremoFunctionWithDefaultParameters(SopremoFunction originalFunction, int minimumNumberOfParameters, int maximumNumberOfParameters) {
        super(minimumNumberOfParameters, maximumNumberOfParameters);
        this.originalFunction = originalFunction;
    }

    SopremoFunctionWithDefaultParameters() {
        super(0, 0);
        this.originalFunction = null;
    }

    @Override
    public IJsonNode call(IArrayNode<IJsonNode> params) {
        for (int index = params.size(); index < this.getMaximumNumberOfParameters(); ++index) {
            params.set(index, this.defaultParameters.get(index));
        }
        return (IJsonNode)this.originalFunction.call(params);
    }

    public IJsonNode getDefaultParameter(int index) {
        return this.defaultParameters.get(index);
    }

    public void setDefaultParameter(int index, IJsonNode node) {
        this.defaultParameters.set(index, node);
    }
}

