/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.function;

import eu.stratosphere.sopremo.SopremoEnvironment;
import eu.stratosphere.sopremo.function.Callable;
import eu.stratosphere.sopremo.function.SopremoFunctionWithDefaultParameters;
import eu.stratosphere.sopremo.packages.BuiltinUtil;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;

public abstract class SopremoFunction
extends Callable<IJsonNode, IArrayNode<IJsonNode>> {
    public SopremoFunction(int numberOfParameters) {
        super(numberOfParameters, numberOfParameters);
    }

    public SopremoFunction(int minimumNumberOfParameters, int maximumNumberOfParameters) {
        super(minimumNumberOfParameters, maximumNumberOfParameters);
    }

    SopremoFunction() {
        this(0, 0);
    }

    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append(BuiltinUtil.getNames(this, SopremoEnvironment.getInstance().getEvaluationContext().getNameChooserProvider().getFunctionNameChooser())[0]);
    }

    public SopremoFunction bind(IJsonNode ... boundParameters) {
        int fixedParameters = this.getMinimumNumberOfParameters() - boundParameters.length;
        SopremoFunctionWithDefaultParameters sfdp = new SopremoFunctionWithDefaultParameters(this, fixedParameters, fixedParameters);
        for (int index = 0; index < boundParameters.length; ++index) {
            sfdp.setDefaultParameter(fixedParameters + index, boundParameters[index]);
        }
        return sfdp;
    }

    @Override
    public SopremoFunction clone() {
        return (SopremoFunction)super.clone();
    }

    public SopremoFunction withDefaultParameters(IJsonNode ... defaultValues) {
        int fixedParameters = this.getMinimumNumberOfParameters() - defaultValues.length;
        SopremoFunctionWithDefaultParameters sfdp = new SopremoFunctionWithDefaultParameters(this, fixedParameters);
        for (int index = 0; index < defaultValues.length; ++index) {
            sfdp.setDefaultParameter(fixedParameters + index, defaultValues[index]);
        }
        return sfdp;
    }
}

