/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.function;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import eu.stratosphere.sopremo.aggregation.Aggregation;
import eu.stratosphere.sopremo.aggregation.AggregationFunction;
import eu.stratosphere.sopremo.expressions.AggregationExpression;
import eu.stratosphere.sopremo.expressions.BatchAggregationExpression;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.ExpressionUtil;
import eu.stratosphere.sopremo.expressions.FunctionCall;
import eu.stratosphere.sopremo.function.Callable;
import eu.stratosphere.sopremo.function.ExpressionFunction;
import eu.stratosphere.sopremo.function.MacroBase;
import eu.stratosphere.sopremo.function.SopremoFunction;
import eu.stratosphere.sopremo.packages.DefaultFunctionRegistry;

public class FunctionUtil {
    public static EvaluationExpression addToBatch(BatchAggregationExpression bae, Aggregation aggregation) {
        return bae.add(aggregation);
    }

    public static EvaluationExpression addToBatch(BatchAggregationExpression bae, Aggregation aggregation, EvaluationExpression preprocessing) {
        return bae.add(aggregation, preprocessing);
    }

    public static EvaluationExpression addToBatch(BatchAggregationExpression bae, ExpressionFunction aggregation) {
        return FunctionUtil.addToBatch(bae, aggregation, (EvaluationExpression)EvaluationExpression.VALUE);
    }

    public static EvaluationExpression addToBatch(final BatchAggregationExpression bae, ExpressionFunction aggregation, EvaluationExpression preprocessing) {
        return aggregation.inline(preprocessing).replace((Predicate<? super EvaluationExpression>)Predicates.instanceOf(AggregationExpression.class), new Function<EvaluationExpression, EvaluationExpression>(){

            public EvaluationExpression apply(EvaluationExpression expression) {
                AggregationExpression ae = (AggregationExpression)expression;
                return bae.add(ae.getAggregation(), ExpressionUtil.replaceArrayProjections(ae.getInputExpression()));
            }
        });
    }

    public static EvaluationExpression createFunctionCall(Aggregation aggregation, EvaluationExpression ... params) {
        return FunctionUtil.createMethodCall(new AggregationFunction(aggregation), null, params);
    }

    public static EvaluationExpression createFunctionCall(Callable<?, ?> callable, EvaluationExpression ... params) {
        return FunctionUtil.createMethodCall(callable, null, params);
    }

    public static EvaluationExpression createFunctionCall(Class<?> methodProvider, String methodName, EvaluationExpression ... params) {
        DefaultFunctionRegistry registry = new DefaultFunctionRegistry();
        registry.put(methodProvider);
        return FunctionUtil.createMethodCall(registry.get(methodName), null, params);
    }

    public static EvaluationExpression createMethodCall(Callable<?, ?> callable, EvaluationExpression object, EvaluationExpression ... params) {
        if (callable instanceof MacroBase) {
            return ((MacroBase)callable).call(params);
        }
        if (!(callable instanceof SopremoFunction)) {
            throw new IllegalArgumentException(String.format("Unknown callable %s", callable));
        }
        if (object != null) {
            EvaluationExpression[] shiftedParams = new EvaluationExpression[params.length + 1];
            System.arraycopy(params, 0, shiftedParams, 1, params.length);
            params = shiftedParams;
            params[0] = object;
        }
        if (callable instanceof ExpressionFunction) {
            return ((ExpressionFunction)callable).inline(params);
        }
        return new FunctionCall((SopremoFunction)callable, params);
    }
}

