/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.function;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.InputSelection;
import eu.stratosphere.sopremo.expressions.TransformFunction;
import eu.stratosphere.sopremo.function.SopremoFunction;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;

public class ExpressionFunction
extends SopremoFunction {
    private final EvaluationExpression definition;

    public ExpressionFunction() {
        super(0, 0);
        this.definition = null;
    }

    public ExpressionFunction(int numParams, EvaluationExpression definition) {
        super(numParams, numParams);
        this.definition = definition;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append("Sopremo function ");
        this.definition.appendAsString(appendable);
    }

    @Override
    public IJsonNode call(IArrayNode<IJsonNode> params) {
        return this.definition.evaluate(params);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionFunction other = (ExpressionFunction)obj;
        return this.definition.equals(other.definition);
    }

    public EvaluationExpression getDefinition() {
        return this.definition;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.definition.hashCode();
        return result;
    }

    public EvaluationExpression inline(final EvaluationExpression ... paramList) {
        return this.getDefinition().clone().replace((Predicate<? super EvaluationExpression>)Predicates.instanceOf(InputSelection.class), new TransformFunction(){

            public EvaluationExpression apply(EvaluationExpression in) {
                return paramList[((InputSelection)in).getIndex()].clone();
            }
        }).simplify();
    }
}

