/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.function;

import eu.stratosphere.sopremo.AbstractSopremoType;
import eu.stratosphere.sopremo.ISopremoType;

public abstract class Callable<Result, InputType>
extends AbstractSopremoType
implements ISopremoType {
    private final int minimumNumberOfParameters;
    private final int maximumNumberOfParameters;

    public Callable(int minimumNumberOfParameters, int maximumNumberOfParameters) {
        this.minimumNumberOfParameters = minimumNumberOfParameters;
        this.maximumNumberOfParameters = maximumNumberOfParameters;
    }

    public boolean accepts(int numberOfArguments) {
        return this.minimumNumberOfParameters <= numberOfArguments && numberOfArguments <= this.maximumNumberOfParameters;
    }

    public abstract Result call(InputType var1);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Callable other = (Callable)obj;
        return this.maximumNumberOfParameters == other.maximumNumberOfParameters && this.minimumNumberOfParameters == other.minimumNumberOfParameters;
    }

    public int getMaximumNumberOfParameters() {
        return this.maximumNumberOfParameters;
    }

    public int getMinimumNumberOfParameters() {
        return this.minimumNumberOfParameters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maximumNumberOfParameters;
        result = 31 * result + this.minimumNumberOfParameters;
        return result;
    }
}

