/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions.tree;

import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;

public abstract class NamedChildIterator
implements ChildIterator {
    private int index = -1;
    private final String[] childNames;

    public NamedChildIterator(String ... childNames) {
        this.childNames = childNames;
    }

    @Override
    public void add(EvaluationExpression childExpression) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canChildBeRemoved() {
        return false;
    }

    @Override
    public String getChildName() {
        return this.childNames[this.index];
    }

    @Override
    public boolean hasNext() {
        return this.index < this.childNames.length - 1;
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public EvaluationExpression next() {
        return this.get(++this.index);
    }

    @Override
    public int nextIndex() {
        return this.index + 1;
    }

    @Override
    public EvaluationExpression previous() {
        return this.get(--this.index);
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(EvaluationExpression childExpression) {
        this.set(this.index, childExpression);
    }

    protected abstract EvaluationExpression get(int var1);

    protected String[] getChildNames() {
        return this.childNames;
    }

    protected int getSize() {
        return this.childNames.length;
    }

    protected abstract void set(int var1, EvaluationExpression var2);
}

