/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions.tree;

import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.tree.NamedChildIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;

public class ConcatenatingNamedChildIterator
extends NamedChildIterator {
    private final NamedChildIterator[] iterators;
    private final int[] startIndexes;

    public ConcatenatingNamedChildIterator(NamedChildIterator ... iterators) {
        super(ConcatenatingNamedChildIterator.concatenateNames(iterators));
        this.iterators = iterators;
        this.startIndexes = new int[iterators.length];
        this.startIndexes[0] = 0;
        for (int index = 1; index < iterators.length; ++index) {
            this.startIndexes[index] = this.startIndexes[index - 1] + iterators[index - 1].getSize();
        }
    }

    @Override
    public boolean hasNext() {
        return super.hasNext();
    }

    @Override
    protected EvaluationExpression get(int index) {
        int iteratorIndex = this.getIteratorIndex(index);
        return this.iterators[iteratorIndex].get(index - this.startIndexes[iteratorIndex]);
    }

    @Override
    protected void set(int index, EvaluationExpression childExpression) {
        int iteratorIndex = this.getIteratorIndex(index);
        this.iterators[iteratorIndex].set(index - this.startIndexes[iteratorIndex], childExpression);
    }

    private int getIteratorIndex(int index) {
        int iteratorIndex = Arrays.binarySearch(this.startIndexes, index);
        if (iteratorIndex < 0) {
            iteratorIndex = -iteratorIndex - 2;
        }
        return iteratorIndex;
    }

    private static String[] concatenateNames(NamedChildIterator[] iterators) {
        ObjectArrayList names = new ObjectArrayList();
        for (NamedChildIterator namedChildIterator : iterators) {
            names.addElements(names.size(), (Object[])namedChildIterator.getChildNames());
        }
        return (String[])names.toArray((Object[])new String[names.size()]);
    }
}

