/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions.tree;

import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import java.util.NoSuchElementException;

public class ConcatenatingChildIterator
implements ChildIterator {
    private final ChildIterator[] iterators;
    private int currentIterator = 0;
    private int index = -1;

    public ConcatenatingChildIterator(ChildIterator ... iterators) {
        this.iterators = iterators;
    }

    @Override
    public void add(EvaluationExpression e) {
        this.checkValidState();
        this.iterators[this.currentIterator].add(e);
    }

    @Override
    public boolean canChildBeRemoved() {
        this.checkValidState();
        return this.iterators[this.currentIterator].canChildBeRemoved();
    }

    @Override
    public String getChildName() {
        this.checkValidState();
        return this.iterators[this.currentIterator].getChildName();
    }

    @Override
    public boolean hasNext() {
        while (this.currentIterator < this.iterators.length) {
            if (this.iterators[this.currentIterator].hasNext()) {
                return true;
            }
            ++this.currentIterator;
        }
        return false;
    }

    @Override
    public boolean hasPrevious() {
        while (this.currentIterator > 0) {
            if (this.iterators[this.currentIterator].hasPrevious()) {
                return true;
            }
            --this.currentIterator;
        }
        return this.iterators[this.currentIterator].hasPrevious();
    }

    @Override
    public EvaluationExpression next() {
        while (this.currentIterator < this.iterators.length) {
            if (this.iterators[this.currentIterator].hasNext()) {
                ++this.index;
                return (EvaluationExpression)this.iterators[this.currentIterator].next();
            }
            ++this.currentIterator;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.index + 1;
    }

    @Override
    public EvaluationExpression previous() {
        while (this.currentIterator > 0) {
            if (this.iterators[this.currentIterator].hasPrevious()) {
                --this.index;
                return (EvaluationExpression)this.iterators[this.currentIterator].previous();
            }
            --this.currentIterator;
        }
        if (this.iterators[this.currentIterator].hasPrevious()) {
            --this.index;
            return (EvaluationExpression)this.iterators[this.currentIterator].previous();
        }
        throw new NoSuchElementException();
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void remove() {
        this.checkValidState();
        this.iterators[this.currentIterator].remove();
    }

    @Override
    public void set(EvaluationExpression e) {
        this.checkValidState();
        this.iterators[this.currentIterator].set(e);
    }

    private void checkValidState() {
        if (this.index < 0) {
            throw new IllegalStateException("Not initialized yet");
        }
        if (this.currentIterator >= this.iterators.length) {
            throw new IllegalStateException("No more iterators");
        }
    }
}

