/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.cache.NodeCache;
import eu.stratosphere.sopremo.expressions.BooleanExpression;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.NamedChildIterator;
import eu.stratosphere.sopremo.type.BooleanNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.TypeCoercer;
import java.io.IOException;

@OptimizerHints(scope={Scope.ANY})
public class UnaryExpression
extends BooleanExpression {
    private EvaluationExpression expr;
    private final boolean negate;
    private final transient NodeCache nodeCache = new NodeCache();

    public UnaryExpression(EvaluationExpression booleanExpr) {
        this(booleanExpr, false);
    }

    public UnaryExpression(EvaluationExpression booleanExpr, boolean negate) {
        this.expr = booleanExpr;
        this.negate = negate;
    }

    UnaryExpression() {
        this.expr = null;
        this.negate = false;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        if (this.negate) {
            appendable.append("!");
        }
        this.expr.appendAsString(appendable);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        UnaryExpression other = (UnaryExpression)obj;
        return this.expr.equals(other.expr) && this.negate == other.negate;
    }

    @Override
    public BooleanNode evaluate(IJsonNode node) {
        BooleanNode result = (BooleanNode)((Object)TypeCoercer.INSTANCE.coerce(this.expr.evaluate(node), this.nodeCache, BooleanNode.class));
        if (this.negate) {
            return result == BooleanNode.TRUE ? BooleanNode.FALSE : BooleanNode.TRUE;
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.expr.hashCode();
        result = 31 * result + (this.negate ? 1231 : 1237);
        return result;
    }

    @Override
    public ChildIterator iterator() {
        return new NamedChildIterator(new String[]{"expr"}){

            @Override
            protected EvaluationExpression get(int index) {
                return UnaryExpression.this.expr;
            }

            @Override
            protected void set(int index, EvaluationExpression e) {
                UnaryExpression.this.expr = e;
            }
        };
    }

    public static BooleanExpression not(EvaluationExpression expression) {
        return new UnaryExpression(expression, true);
    }
}

