/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.cache.NodeCache;
import eu.stratosphere.sopremo.expressions.ConstantExpression;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.ConcatenatingNamedChildIterator;
import eu.stratosphere.sopremo.expressions.tree.NamedChildIterator;
import eu.stratosphere.sopremo.type.BooleanNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.TypeCoercer;
import java.io.IOException;

public class TernaryExpression
extends PathSegmentExpression {
    private EvaluationExpression ifClause;
    private EvaluationExpression ifExpression;
    private EvaluationExpression thenExpression;
    private final transient NodeCache nodeCache = new NodeCache();

    public TernaryExpression() {
        this.ifClause = null;
        this.ifExpression = null;
        this.thenExpression = null;
    }

    public TernaryExpression(EvaluationExpression ifClause, EvaluationExpression ifExpression) {
        this(ifClause, ifExpression, ConstantExpression.MISSING);
    }

    public TernaryExpression(EvaluationExpression ifClause, EvaluationExpression ifExpression, EvaluationExpression thenExpression) {
        this.ifClause = ifClause;
        this.ifExpression = ifExpression;
        this.thenExpression = thenExpression;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        this.ifClause.appendAsString(appendable);
        appendable.append(" ? ");
        this.ifExpression.appendAsString(appendable);
        appendable.append(" : ");
        this.thenExpression.appendAsString(appendable);
    }

    public EvaluationExpression getIfClause() {
        return this.ifClause;
    }

    public EvaluationExpression getIfExpression() {
        return this.ifExpression;
    }

    public EvaluationExpression getThenExpression() {
        return this.thenExpression;
    }

    @Override
    public ChildIterator iterator() {
        return new ConcatenatingNamedChildIterator(super.namedChildIterator(), new NamedChildIterator(new String[]{"ifClause", "ifExpression", "thenExpression"}){

            @Override
            protected EvaluationExpression get(int index) {
                switch (index) {
                    case 0: {
                        return TernaryExpression.this.ifClause;
                    }
                    case 1: {
                        return TernaryExpression.this.ifExpression;
                    }
                }
                return TernaryExpression.this.thenExpression;
            }

            @Override
            protected void set(int index, EvaluationExpression childExpression) {
                switch (index) {
                    case 0: {
                        TernaryExpression.this.ifClause = childExpression;
                        break;
                    }
                    case 1: {
                        TernaryExpression.this.ifExpression = childExpression;
                        break;
                    }
                    default: {
                        TernaryExpression.this.thenExpression = childExpression;
                    }
                }
            }
        });
    }

    @Override
    protected boolean equalsSameClass(PathSegmentExpression obj) {
        TernaryExpression other = (TernaryExpression)obj;
        return this.ifClause.equals(other.ifClause) && this.ifExpression.equals(other.ifExpression) && this.thenExpression.equals(other.thenExpression);
    }

    @Override
    protected IJsonNode evaluateSegment(IJsonNode node) {
        if (TypeCoercer.INSTANCE.coerce(this.ifClause.evaluate(node), this.nodeCache, BooleanNode.class) == BooleanNode.TRUE) {
            return this.ifExpression.evaluate(node);
        }
        return this.thenExpression.evaluate(node);
    }

    @Override
    protected int segmentHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.ifClause.hashCode();
        result = 31 * result + this.ifExpression.hashCode();
        result = 31 * result + this.thenExpression.hashCode();
        return result;
    }
}

