/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;

@OptimizerHints(scope={Scope.OBJECT})
public class SetValueExpression
extends PathSegmentExpression {
    private final PathSegmentExpression valueLocator;
    private final EvaluationExpression replaceExpression;

    public SetValueExpression(PathSegmentExpression valueLocator, EvaluationExpression replaceExpression) {
        this.valueLocator = valueLocator;
        this.replaceExpression = replaceExpression;
    }

    SetValueExpression() {
        this.valueLocator = EvaluationExpression.VALUE;
        this.replaceExpression = EvaluationExpression.VALUE;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        this.appendInputAsString(appendable);
        this.valueLocator.appendAsString(appendable);
        appendable.append("<-");
        this.replaceExpression.appendAsString(appendable);
    }

    @Override
    public boolean equalsSameClass(PathSegmentExpression other) {
        SetValueExpression setValueExpression = (SetValueExpression)other;
        return this.valueLocator.equals(setValueExpression.valueLocator) && this.replaceExpression.equals(setValueExpression.replaceExpression);
    }

    public EvaluationExpression getReplaceExpression() {
        return this.replaceExpression;
    }

    public EvaluationExpression getValueLocator() {
        return this.valueLocator;
    }

    @Override
    protected IJsonNode evaluateSegment(IJsonNode node) {
        return this.valueLocator.set(node, this.replaceExpression.evaluate(node));
    }

    @Override
    protected int segmentHashCode() {
        return 41 * this.valueLocator.hashCode() + this.replaceExpression.hashCode();
    }
}

