/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.NamedChildIterator;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;

public abstract class PathSegmentExpression
extends EvaluationExpression {
    private EvaluationExpression inputExpression = EvaluationExpression.VALUE;

    @Override
    public PathSegmentExpression clone() {
        return (PathSegmentExpression)super.clone();
    }

    public PathSegmentExpression cloneSegment() {
        EvaluationExpression originalInput = this.inputExpression;
        this.inputExpression = EvaluationExpression.VALUE;
        PathSegmentExpression partialClone = this.clone();
        this.inputExpression = originalInput;
        return partialClone;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathSegmentExpression other = (PathSegmentExpression)obj;
        return this.equalsSameClass(other) && this.inputExpression.equals(other.inputExpression);
    }

    public boolean equalsThisSeqment(PathSegmentExpression obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsSameClass(obj);
    }

    @Override
    public IJsonNode evaluate(IJsonNode node) {
        return this.evaluateSegment(this.getInputExpression().evaluate(node));
    }

    public EvaluationExpression getInputExpression() {
        return this.inputExpression;
    }

    public PathSegmentExpression getLast() {
        PathSegmentExpression segment = this;
        while (segment.inputExpression != EvaluationExpression.VALUE && this.inputExpression instanceof PathSegmentExpression) {
            segment = (PathSegmentExpression)this.inputExpression;
        }
        return segment;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.inputExpression.hashCode();
        result = 31 * result + this.segmentHashCode();
        return result;
    }

    @Override
    public ChildIterator iterator() {
        return this.namedChildIterator();
    }

    public IJsonNode set(IJsonNode node, IJsonNode value) {
        if (this.getInputExpression() == EvaluationExpression.VALUE) {
            return this.setSegment(node, value);
        }
        this.setSegment(this.getInputExpression().evaluate(node), value);
        return node;
    }

    public void setInputExpression(EvaluationExpression inputExpression) {
        if (inputExpression == null) {
            throw new NullPointerException("inputExpression must not be null");
        }
        this.inputExpression = inputExpression;
    }

    public PathSegmentExpression withInputExpression(EvaluationExpression inputExpression) {
        this.setInputExpression(inputExpression);
        return this;
    }

    public PathSegmentExpression withTail(EvaluationExpression tail) {
        this.getLast().setInputExpression(tail);
        return this;
    }

    protected void appendInputAsString(Appendable appendable) throws IOException {
        if (this.inputExpression != EvaluationExpression.VALUE) {
            this.inputExpression.appendAsString(appendable);
        }
    }

    protected abstract boolean equalsSameClass(PathSegmentExpression var1);

    protected abstract IJsonNode evaluateSegment(IJsonNode var1);

    protected NamedChildIterator namedChildIterator() {
        return new NamedChildIterator(new String[]{"inputExpression"}){

            @Override
            protected EvaluationExpression get(int index) {
                return PathSegmentExpression.this.inputExpression;
            }

            @Override
            protected void set(int index, EvaluationExpression childExpression) {
                PathSegmentExpression.this.inputExpression = childExpression;
            }
        };
    }

    protected abstract int segmentHashCode();

    protected IJsonNode setSegment(IJsonNode node, IJsonNode value) {
        throw new UnsupportedOperationException(String.format("Cannot change the value with expression %s of node %s to %s", this, node, value));
    }
}

