/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.api.common.operators.Order;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IntNode;
import java.io.IOException;
import java.util.Comparator;

public class OrderingExpression
extends EvaluationExpression {
    private Order order;
    private EvaluationExpression path;
    private final transient IntNode result = new IntNode();

    public OrderingExpression() {
        this(Order.ASCENDING, EvaluationExpression.VALUE);
    }

    public OrderingExpression(Order order, PathSegmentExpression path) {
        this.order = order;
        this.path = path;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append(this.order.toString()).append(' ');
        this.path.appendAsString(appendable);
    }

    public Comparator<IJsonNode> asComparator() {
        return new Comparator<IJsonNode>(){

            @Override
            public int compare(IJsonNode node1, IJsonNode node2) {
                int result = OrderingExpression.this.path.evaluate(node1).compareTo(OrderingExpression.this.path.evaluate(node2));
                return OrderingExpression.this.order == Order.DESCENDING ? -result : result;
            }
        };
    }

    public int compare(IJsonNode node1, IJsonNode node2) {
        int result = this.path.evaluate(node1).compareTo(this.path.evaluate(node2));
        return this.order == Order.DESCENDING ? -result : result;
    }

    @Override
    public IntNode evaluate(IJsonNode node) {
        IArrayNode pair = (IArrayNode)node;
        this.result.setValue(this.compare((IJsonNode)pair.get(0), (IJsonNode)pair.get(1)));
        return this.result;
    }

    public Order getOrder() {
        return this.order;
    }

    public EvaluationExpression getPath() {
        return this.path;
    }

    public void setOrder(Order order) {
        if (order == null) {
            throw new NullPointerException("order must not be null");
        }
        this.order = order;
    }

    public void setPath(EvaluationExpression path) {
        if (path == null) {
            throw new NullPointerException("path must not be null");
        }
        this.path = path;
    }
}

