/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.expressions.BooleanExpression;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.GenericListChildIterator;
import eu.stratosphere.sopremo.type.BooleanNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@OptimizerHints(scope={Scope.ANY})
public class OrExpression
extends BooleanExpression {
    private final List<BooleanExpression> expressions;

    public OrExpression() {
        this(new ArrayList<BooleanExpression>());
    }

    public OrExpression(BooleanExpression ... expressions) {
        this(Arrays.asList(expressions));
    }

    public OrExpression(List<BooleanExpression> expressions) {
        this.expressions = new ArrayList<BooleanExpression>(expressions);
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        this.append(appendable, this.expressions, " OR ");
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        OrExpression other = (OrExpression)obj;
        return this.expressions.equals(other.expressions);
    }

    @Override
    public BooleanNode evaluate(IJsonNode node) {
        for (EvaluationExpression evaluationExpression : this.expressions) {
            if (evaluationExpression.evaluate(node) != BooleanNode.TRUE) continue;
            return BooleanNode.TRUE;
        }
        return BooleanNode.FALSE;
    }

    public List<BooleanExpression> getExpressions() {
        return this.expressions;
    }

    @Override
    public int hashCode() {
        int prime = 41;
        int result = super.hashCode();
        result = 41 * result + this.expressions.hashCode();
        return result;
    }

    @Override
    public ChildIterator iterator() {
        return new GenericListChildIterator<BooleanExpression>(this.expressions.listIterator()){

            @Override
            protected BooleanExpression convert(EvaluationExpression childExpression) {
                return BooleanExpression.ensureBooleanExpression(childExpression);
            }
        };
    }

    public static OrExpression valueOf(BooleanExpression expression) {
        if (expression instanceof OrExpression) {
            return (OrExpression)expression;
        }
        return new OrExpression(expression);
    }

    public static OrExpression valueOf(List<? extends EvaluationExpression> childConditions) {
        List<BooleanExpression> booleans = BooleanExpression.ensureBooleanExpressions(childConditions);
        if (booleans.size() == 1) {
            return OrExpression.valueOf(booleans.get(0));
        }
        return new OrExpression(booleans.toArray(new BooleanExpression[booleans.size()]));
    }
}

