/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.AbstractSopremoType;
import eu.stratosphere.sopremo.EvaluationException;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.ObjectAccess;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

@OptimizerHints(scope={Scope.ANY})
public class ObjectCreation
extends EvaluationExpression {
    public static final ObjectCreation CONCATENATION = new Concatenation();
    private final List<Mapping<?>> mappings;
    private final transient IObjectNode result = new ObjectNode();

    public ObjectCreation() {
        this(new ArrayList());
    }

    public ObjectCreation(FieldAssignment ... mappings) {
        this.mappings = new ArrayList<FieldAssignment>(Arrays.asList(mappings));
    }

    public ObjectCreation(List<Mapping<?>> mappings) {
        this.mappings = mappings;
    }

    public ObjectCreation addMapping(Mapping<?> mapping) {
        if (mapping == null) {
            throw new NullPointerException();
        }
        this.mappings.add(mapping);
        return this;
    }

    public ObjectCreation addMapping(PathSegmentExpression target, EvaluationExpression expression) {
        if (target == null || expression == null) {
            throw new NullPointerException();
        }
        this.mappings.add(new ExpressionAssignment(target, expression));
        return this;
    }

    public ObjectCreation addMapping(String target, EvaluationExpression expression) {
        if (target == null || expression == null) {
            throw new NullPointerException();
        }
        this.mappings.add(new FieldAssignment(target, expression));
        return this;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append("{");
        Iterator<Mapping<?>> mappingIterator = this.mappings.iterator();
        while (mappingIterator.hasNext()) {
            Mapping<?> entry = mappingIterator.next();
            entry.appendAsString(appendable);
            if (!mappingIterator.hasNext()) continue;
            appendable.append(", ");
        }
        appendable.append("}");
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ObjectCreation other = (ObjectCreation)obj;
        return this.mappings.equals(other.mappings);
    }

    @Override
    public IJsonNode evaluate(IJsonNode node) {
        this.result.clear();
        for (Mapping<?> mapping : this.mappings) {
            mapping.evaluate(node, this.result);
        }
        return this.result;
    }

    public Mapping<?> getMapping(int index) {
        return this.mappings.get(index);
    }

    public List<Mapping<?>> getMappings() {
        return this.mappings;
    }

    public int getMappingSize() {
        return this.mappings.size();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.mappings.hashCode();
        return result;
    }

    @Override
    public ChildIterator iterator() {
        return new MappingIterator();
    }

    static /* synthetic */ List access$200(ObjectCreation x0) {
        return x0.mappings;
    }

    private final class MappingIterator
    implements ChildIterator {
        private boolean lastReturnedWasKey = false;
        private final ListIterator<Mapping<?>> iterator = ObjectCreation.access$200(ObjectCreation.this).listIterator();
        private Mapping<?> lastMapping;
        private int index = 0;

        private MappingIterator() {
        }

        @Override
        public void add(EvaluationExpression e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canChildBeRemoved() {
            return false;
        }

        @Override
        public String getChildName() {
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.lastReturnedWasKey || this.iterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious() || !this.lastReturnedWasKey && this.lastMapping.target instanceof EvaluationExpression;
        }

        @Override
        public EvaluationExpression next() {
            ++this.index;
            if (this.lastReturnedWasKey) {
                return this.lastMapping.expression;
            }
            this.lastMapping = this.iterator.next();
            this.lastReturnedWasKey = this.lastMapping.target instanceof EvaluationExpression;
            if (this.lastReturnedWasKey) {
                return (EvaluationExpression)this.lastMapping.target;
            }
            return this.lastMapping.expression;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public EvaluationExpression previous() {
            --this.index;
            if (!this.lastReturnedWasKey && (this.lastReturnedWasKey = this.lastMapping.target instanceof EvaluationExpression)) {
                return (EvaluationExpression)this.lastMapping.target;
            }
            return this.lastMapping.expression;
        }

        @Override
        public int previousIndex() {
            return this.index;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(EvaluationExpression e) {
            if (this.lastReturnedWasKey) {
                this.lastMapping.target = e;
            } else {
                this.lastMapping.expression = e;
            }
        }
    }

    private static final class Concatenation
    extends ObjectCreation {
        private final transient IObjectNode result = new ObjectNode();

        private Concatenation() {
        }

        @Override
        public IJsonNode evaluate(IJsonNode node) {
            this.result.clear();
            for (IJsonNode jsonNode : (IArrayNode)node) {
                if (jsonNode == MissingNode.getInstance()) continue;
                this.result.putAll((IObjectNode)jsonNode);
            }
            return this.result;
        }
    }

    public static class TagMapping
    extends Mapping<EvaluationExpression> {
        public TagMapping(EvaluationExpression target, EvaluationExpression expression) {
            super(target, expression);
        }

        TagMapping() {
        }

        @Override
        public PathSegmentExpression getTargetExpression() {
            return (PathSegmentExpression)this.target;
        }

        @Override
        public EvaluationExpression getTargetTagExpression() {
            return (EvaluationExpression)this.target;
        }

        @Override
        protected void appendTarget(Appendable appendable) throws IOException {
            ((EvaluationExpression)this.target).appendAsString(appendable);
        }

        @Override
        protected void evaluate(IJsonNode node, IObjectNode target) {
            throw new EvaluationException("Only tag mapping");
        }
    }

    public static abstract class Mapping<Target>
    extends AbstractSopremoType {
        protected Target target;
        protected EvaluationExpression expression;

        public Mapping(Target target, EvaluationExpression expression) {
            this.target = target;
            this.expression = expression;
        }

        Mapping() {
        }

        public void appendAsString(Appendable appendable) throws IOException {
            this.appendTarget(appendable);
            appendable.append("=");
            this.expression.appendAsString(appendable);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mapping other = (Mapping)obj;
            return this.target.equals(other.target) && this.expression.equals(other.expression);
        }

        public EvaluationExpression getExpression() {
            return this.expression;
        }

        public Target getTarget() {
            return this.target;
        }

        public abstract PathSegmentExpression getTargetExpression();

        public EvaluationExpression getTargetTagExpression() {
            return this.getTargetExpression();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.expression.hashCode();
            result = 31 * result + this.target.hashCode();
            return result;
        }

        public void setExpression(EvaluationExpression expression) {
            if (expression == null) {
                throw new NullPointerException("expression must not be null");
            }
            this.expression = expression;
        }

        protected abstract void appendTarget(Appendable var1) throws IOException;

        protected abstract void evaluate(IJsonNode var1, IObjectNode var2);
    }

    public static class FieldAssignment
    extends Mapping<String> {
        public FieldAssignment(String target, EvaluationExpression expression) {
            super(target, expression);
        }

        FieldAssignment() {
        }

        @Override
        public PathSegmentExpression getTargetExpression() {
            return new ObjectAccess((String)this.target);
        }

        @Override
        protected void appendTarget(Appendable appendable) throws IOException {
            appendable.append((CharSequence)this.target);
        }

        @Override
        protected void evaluate(IJsonNode node, IObjectNode target) {
            IJsonNode value = this.expression.evaluate(node);
            target.put((String)this.target, value);
        }
    }

    public static class ExpressionAssignment
    extends Mapping<PathSegmentExpression> {
        private IJsonNode lastResult;

        public ExpressionAssignment(PathSegmentExpression target, EvaluationExpression expression) {
            super(target, expression);
        }

        ExpressionAssignment() {
        }

        @Override
        public PathSegmentExpression getTargetExpression() {
            return (PathSegmentExpression)this.target;
        }

        @Override
        protected void appendTarget(Appendable appendable) throws IOException {
            ((PathSegmentExpression)this.target).appendAsString(appendable);
        }

        @Override
        protected void evaluate(IJsonNode node, IObjectNode target) {
            this.lastResult = this.expression.evaluate(node);
            ((PathSegmentExpression)this.target).set(target, this.lastResult);
        }
    }

    public static class CopyFields
    extends FieldAssignment {
        public CopyFields(EvaluationExpression expression) {
            super("*", expression);
        }

        CopyFields() {
        }

        @Override
        public void appendAsString(Appendable appendable) throws IOException {
            this.getExpression().appendAsString(appendable);
            appendable.append(".*");
        }

        @Override
        public PathSegmentExpression getTargetExpression() {
            return EvaluationExpression.VALUE;
        }

        @Override
        protected void evaluate(IJsonNode node, IObjectNode target) {
            IJsonNode exprNode = this.getExpression().evaluate(node);
            target.putAll((IObjectNode)exprNode);
        }
    }
}

