/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.EvaluationException;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.NullNode;
import java.io.IOException;

@OptimizerHints(scope={Scope.OBJECT})
public class ObjectAccess
extends PathSegmentExpression {
    private final String field;

    public ObjectAccess(String field) {
        this.field = field;
    }

    ObjectAccess() {
        this.field = null;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        this.appendInputAsString(appendable);
        appendable.append('.').append(this.field);
    }

    @Override
    public boolean equalsSameClass(PathSegmentExpression other) {
        return this.field.equals(((ObjectAccess)other).field);
    }

    public String getField() {
        return this.field;
    }

    @Override
    protected IJsonNode evaluateSegment(IJsonNode node) {
        if (!(node instanceof IObjectNode)) {
            return MissingNode.getInstance();
        }
        Object value = ((IObjectNode)node).get(this.field);
        return value == null ? NullNode.getInstance() : value;
    }

    @Override
    protected int segmentHashCode() {
        return this.field.hashCode();
    }

    @Override
    protected IJsonNode setSegment(IJsonNode node, IJsonNode value) {
        if (!(node instanceof IObjectNode)) {
            throw new EvaluationException("Cannot set field of non-object " + node.getClass().getSimpleName());
        }
        SopremoUtil.replaceWithCopy((IObjectNode)node, this.field, value);
        return node;
    }
}

