/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.InputSelection;
import eu.stratosphere.sopremo.expressions.UnevaluableExpression;
import eu.stratosphere.sopremo.operator.JsonStream;
import eu.stratosphere.sopremo.operator.Operator;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import javolution.text.TypeFormat;

public class JsonStreamExpression
extends UnevaluableExpression {
    private final JsonStream stream;
    private final int inputIndex;
    private transient WeakReference<JsonStreamExpression> equalStream;

    public JsonStreamExpression(int inputIndex) {
        this(null, inputIndex);
    }

    public JsonStreamExpression(JsonStream stream) {
        this(stream, -1);
    }

    public JsonStreamExpression(JsonStream stream, int inputIndex) {
        super("JsonStream placeholder");
        this.stream = stream;
        this.inputIndex = inputIndex;
    }

    JsonStreamExpression() {
        super("JsonStream placeholder");
        this.stream = null;
        this.inputIndex = 0;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        if (this.stream != null) {
            appendable.append(this.stream.getSource().getOperator().getName()).append("@");
        }
        if (this.inputIndex != -1) {
            TypeFormat.format((int)this.inputIndex, (Appendable)appendable);
        } else if (this.stream != null) {
            TypeFormat.format((int)this.stream.getSource().getIndex(), (Appendable)appendable);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonStreamExpression other = (JsonStreamExpression)obj;
        Operator.Output thisSource = this.stream.getSource();
        Operator.Output otherSource = other.stream.getSource();
        if (thisSource.getIndex() != otherSource.getIndex()) {
            return false;
        }
        if (this.equalStream != null && this.equalStream.get() == other) {
            return true;
        }
        this.equalStream = new WeakReference<JsonStreamExpression>(other);
        return thisSource.getOperator().equals(otherSource.getOperator());
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    public int getInputIndex(List<JsonStream> inputs) {
        if (this.inputIndex != -1) {
            return this.inputIndex;
        }
        return inputs.indexOf(this.stream);
    }

    public JsonStream getStream() {
        return this.stream;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.stream.getSource().hashCode();
        return result;
    }

    public EvaluationExpression toInputSelection(Operator<?> operator) {
        InputSelection inputSelection;
        if (this.inputIndex != -1) {
            inputSelection = new InputSelection(this.inputIndex);
        } else if (operator.getSource() == this.stream.getSource()) {
            inputSelection = new InputSelection(0);
        } else {
            int index = operator.getInputs().indexOf(this.stream.getSource());
            if (index == -1) {
                return this;
            }
            inputSelection = new InputSelection(index);
        }
        return inputSelection;
    }
}

