/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.EvaluationException;
import eu.stratosphere.sopremo.expressions.ArrayAccess;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;
import javolution.text.TypeFormat;

@OptimizerHints(scope={Scope.ANY}, minNodes=1, maxNodes=0x7FFFFFFF)
public class InputSelection
extends PathSegmentExpression {
    private final int index;

    public InputSelection(int index) {
        this.index = index;
    }

    InputSelection() {
        this.index = 0;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        this.appendInputAsString(appendable);
        appendable.append("in");
        TypeFormat.format((int)this.index, (Appendable)appendable);
    }

    public ArrayAccess asArrayAccess() {
        return new ArrayAccess(this.index);
    }

    @Override
    public boolean equalsSameClass(PathSegmentExpression other) {
        return this.index == ((InputSelection)other).index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    protected IJsonNode evaluateSegment(IJsonNode node) {
        if (!(node instanceof IArrayNode)) {
            throw new EvaluationException("Cannot select input " + node.getClass().getSimpleName());
        }
        return ((IArrayNode)node).get(this.index);
    }

    @Override
    protected int segmentHashCode() {
        return this.index;
    }
}

