/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.cache.ExpressionCache;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.NamedChildIterator;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.CachingArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;
import javolution.util.FastMap;

public class GroupingExpression
extends EvaluationExpression {
    private EvaluationExpression groupingExpression;
    private final transient IArrayNode<IJsonNode> result = new ArrayNode<IJsonNode>();
    private ExpressionCache<EvaluationExpression> resultExpressions = new ExpressionCache<Object>(null);
    private final transient FastMap<IJsonNode, CachingArrayNode<IJsonNode>> groups = new FastMap();

    public GroupingExpression(EvaluationExpression groupingExpression, EvaluationExpression resultExpression) {
        this.groupingExpression = groupingExpression;
        this.resultExpressions = new ExpressionCache<EvaluationExpression>(resultExpression);
    }

    GroupingExpression() {
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append("g(");
        this.groupingExpression.appendAsString(appendable);
        appendable.append(") -> ");
        this.getResultExpression().appendAsString(appendable);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        GroupingExpression other = (GroupingExpression)obj;
        return this.groupingExpression.equals(other.groupingExpression) && this.getResultExpression().equals(other.resultExpressions.getTemplate());
    }

    @Override
    public IJsonNode evaluate(IJsonNode node) {
        this.result.clear();
        if (((IArrayNode)node).size() == 0) {
            return this.result;
        }
        this.fillGroups((IArrayNode)node);
        ExpressionCache<EvaluationExpression> resultExpressions = this.resultExpressions;
        int index = 0;
        FastMap.Entry e = this.groups.head();
        FastMap.Entry end = this.groups.tail();
        while ((e = e.getNext()) != end) {
            CachingArrayNode group = (CachingArrayNode)e.getValue();
            if (group.isEmpty()) continue;
            this.result.add(resultExpressions.get(index++).evaluate(group));
        }
        this.emptyGroups();
        return this.result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.groupingExpression.hashCode();
        result = 31 * result + this.getResultExpression().hashCode();
        return result;
    }

    @Override
    public ChildIterator iterator() {
        return new NamedChildIterator(new String[]{"groupingExpression", "second"}){

            @Override
            protected EvaluationExpression get(int index) {
                if (index == 0) {
                    return GroupingExpression.this.groupingExpression;
                }
                return GroupingExpression.this.resultExpressions.getTemplate();
            }

            @Override
            protected void set(int index, EvaluationExpression childExpression) {
                if (index == 0) {
                    GroupingExpression.this.groupingExpression = childExpression;
                } else {
                    GroupingExpression.this.resultExpressions = new ExpressionCache<EvaluationExpression>(childExpression);
                }
            }
        };
    }

    private void emptyGroups() {
        FastMap.Entry e = this.groups.head();
        FastMap.Entry end = this.groups.tail();
        while ((e = e.getNext()) != end) {
            ((CachingArrayNode)e.getValue()).clear();
        }
    }

    private void fillGroups(IArrayNode<?> array) {
        for (IJsonNode node : array) {
            CachingArrayNode<IJsonNode> group;
            IJsonNode key = this.groupingExpression.evaluate(node);
            FastMap.Entry entry = this.groups.getEntry((Object)key);
            if (entry == null) {
                group = new CachingArrayNode<IJsonNode>();
                this.groups.put((Object)key.clone(), group);
            } else {
                group = (CachingArrayNode<IJsonNode>)entry.getValue();
            }
            group.addClone(node);
        }
    }

    private EvaluationExpression getResultExpression() {
        return this.resultExpressions.getTemplate();
    }
}

