/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.EvaluationContext;
import eu.stratosphere.sopremo.SopremoEnvironment;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.TextNode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Formatter;

public class GenerateExpression
extends EvaluationExpression {
    private final String pattern;
    private long id;
    private transient EvaluationContext context;
    private final transient TextNode result = new TextNode();
    private final transient Formatter formatter = new Formatter(this.result);

    public GenerateExpression(String patternString) {
        int patternPos = patternString.indexOf("%");
        if (patternPos == -1) {
            patternString = patternString + "%s_%s";
        } else if (patternString.indexOf("%", patternPos + 1) == -1) {
            patternString = patternString.replaceAll("%", "%s_%");
        }
        this.pattern = patternString;
        this.context = SopremoEnvironment.getInstance().getEvaluationContext();
    }

    @Override
    public IJsonNode evaluate(IJsonNode node) {
        this.result.clear();
        this.formatter.format(this.pattern, this.context.getTaskId(), this.id++);
        return this.result;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.context = SopremoEnvironment.getInstance().getEvaluationContext();
    }
}

