/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.EvaluationException;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.ConcatenatingChildIterator;
import eu.stratosphere.sopremo.expressions.tree.NamedChildIterator;
import eu.stratosphere.sopremo.function.SopremoFunction;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@OptimizerHints(scope={Scope.ANY}, minNodes=0, maxNodes=0x7FFFFFFF)
public class FunctionCall
extends EvaluationExpression {
    private final SopremoFunction function;
    private final List<EvaluationExpression> paramExprs;
    private final transient IArrayNode<IJsonNode> params = new ArrayNode<IJsonNode>();

    public FunctionCall(SopremoFunction function, EvaluationExpression ... params) {
        this(function, Arrays.asList(params));
    }

    public FunctionCall(SopremoFunction function, List<EvaluationExpression> params) {
        if (function == null) {
            throw new NullPointerException("Function must not be null");
        }
        for (EvaluationExpression param : params) {
            if (param != null) continue;
            throw new NullPointerException("Params must not be null " + params);
        }
        this.function = function;
        this.paramExprs = new ArrayList<EvaluationExpression>(params);
    }

    FunctionCall() {
        this.function = null;
        this.paramExprs = null;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        this.function.appendAsString(appendable);
        appendable.append('(');
        this.append(appendable, this.paramExprs, ", ");
        appendable.append(')');
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        FunctionCall other = (FunctionCall)obj;
        return this.function.equals(other.function) && this.paramExprs.equals(other.paramExprs);
    }

    @Override
    public IJsonNode evaluate(IJsonNode node) {
        List<EvaluationExpression> paramExprs = this.paramExprs;
        this.params.clear();
        for (int index = 0; index < paramExprs.size(); ++index) {
            this.params.add(paramExprs.get(index).evaluate(node));
        }
        try {
            return (IJsonNode)this.function.call(this.params);
        }
        catch (Exception e) {
            throw new EvaluationException(e);
        }
    }

    public SopremoFunction getFunction() {
        return this.function;
    }

    public List<EvaluationExpression> getParameters() {
        return this.paramExprs;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 53 + this.function.hashCode();
        hash = hash * 53 + this.paramExprs.hashCode();
        return hash;
    }

    @Override
    public ChildIterator iterator() {
        String[] paramNames = new String[this.paramExprs.size()];
        for (int index = 0; index < paramNames.length; ++index) {
            paramNames[index] = String.format("Param %d", index);
        }
        return new ConcatenatingChildIterator(super.iterator(), new NamedChildIterator(paramNames){

            @Override
            protected EvaluationExpression get(int index) {
                return (EvaluationExpression)FunctionCall.this.paramExprs.get(index);
            }

            @Override
            protected void set(int index, EvaluationExpression childExpression) {
                FunctionCall.this.paramExprs.set(index, childExpression);
            }
        });
    }
}

