/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import eu.stratosphere.sopremo.CoreFunctions;
import eu.stratosphere.sopremo.aggregation.Aggregation;
import eu.stratosphere.sopremo.aggregation.AggregationFunction;
import eu.stratosphere.sopremo.aggregation.ArrayAccessAsAggregation;
import eu.stratosphere.sopremo.cache.NodeCache;
import eu.stratosphere.sopremo.expressions.AggregationExpression;
import eu.stratosphere.sopremo.expressions.ArrayAccess;
import eu.stratosphere.sopremo.expressions.ArrayProjection;
import eu.stratosphere.sopremo.expressions.BatchAggregationExpression;
import eu.stratosphere.sopremo.expressions.ChainedSegmentExpression;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.FunctionCall;
import eu.stratosphere.sopremo.expressions.InputSelection;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.expressions.TransformFunction;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.TypeCoercer;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class ExpressionUtil {
    private static final ThreadLocal<NodeCache> NodeCache = new ThreadLocal<NodeCache>(){

        @Override
        protected NodeCache initialValue() {
            return new NodeCache();
        }
    };

    public static <T extends IJsonNode> T getConstant(EvaluationExpression expression, Class<T> type) {
        IJsonNode constant = expression.evaluate(MissingNode.getInstance());
        return (T)TypeCoercer.INSTANCE.coerce(constant, NodeCache.get(), type);
    }

    public static PathSegmentExpression makePath(List<PathSegmentExpression> expressions) {
        PathSegmentExpression result;
        if (expressions.size() == 0) {
            return EvaluationExpression.VALUE;
        }
        PathSegmentExpression last = result = expressions.get(expressions.size() - 1);
        for (int index = expressions.size() - 2; index >= 0; --index) {
            PathSegmentExpression expression = expressions.get(index);
            last.getLast().setInputExpression(expression);
            last = expression;
        }
        return result;
    }

    public static PathSegmentExpression makePath(PathSegmentExpression ... expressions) {
        return ExpressionUtil.makePath(Arrays.asList(expressions));
    }

    public static EvaluationExpression replaceAggregationWithBatchAggregation(EvaluationExpression baseExpression) {
        List<InputSelection> inputs;
        IdentityHashMap<FunctionCall, EvaluationExpression> aggregatingFunctionCalls = new IdentityHashMap<FunctionCall, EvaluationExpression>();
        IdentityHashMap<AggregationExpression, EvaluationExpression> aggregatingExpressions = new IdentityHashMap<AggregationExpression, EvaluationExpression>();
        ExpressionUtil.findAggregatingFunctionCalls(baseExpression, aggregatingFunctionCalls, aggregatingExpressions, null);
        if (aggregatingFunctionCalls.isEmpty() && aggregatingExpressions.isEmpty()) {
            return baseExpression;
        }
        EvaluationExpression result = baseExpression;
        Int2ObjectOpenHashMap aggregationPerInput = new Int2ObjectOpenHashMap();
        for (FunctionCall functionCall : aggregatingFunctionCalls.keySet()) {
            AggregationFunction aggregationFunction = (AggregationFunction)functionCall.getFunction();
            inputs = functionCall.findAll(InputSelection.class);
            if (inputs.isEmpty()) continue;
            Aggregation aggregation = aggregationFunction.getAggregation();
            int input = inputs.get(0).getIndex();
            for (int index = 1; index < inputs.size(); ++index) {
                if (inputs.get(index).getIndex() == input) continue;
                throw new IllegalArgumentException("Cannot batch process aggregations with multiple inputs");
            }
            List<EvaluationExpression> parameters = functionCall.getParameters();
            BatchAggregationExpression batch = (BatchAggregationExpression)aggregationPerInput.get(input);
            if (batch == null) {
                batch = new BatchAggregationExpression();
                aggregationPerInput.put(input, (Object)batch);
                batch.setInputExpression(new InputSelection(input));
            }
            EvaluationExpression parent = (EvaluationExpression)aggregatingFunctionCalls.get(functionCall);
            AggregationExpression partial = batch.add(aggregation, ExpressionUtil.replaceArrayProjections(parameters.get(0)));
            if (parent == null) {
                result = partial;
                continue;
            }
            parent.replace(functionCall, (EvaluationExpression)partial);
        }
        for (AggregationExpression expression : aggregatingExpressions.keySet()) {
            Aggregation aggregation = expression.getAggregation();
            inputs = expression.getInputExpression().findAll(InputSelection.class);
            if (inputs.isEmpty()) continue;
            int input = inputs.get(0).getIndex();
            for (int index = 1; index < inputs.size(); ++index) {
                if (inputs.get(index).getIndex() == input) continue;
                throw new IllegalArgumentException("Cannot batch process aggregations with multiple inputs");
            }
            BatchAggregationExpression batch = (BatchAggregationExpression)aggregationPerInput.get(input);
            if (batch == null) {
                batch = new BatchAggregationExpression();
                aggregationPerInput.put(input, (Object)batch);
                batch.setInputExpression(new InputSelection(input));
            }
            EvaluationExpression parent = (EvaluationExpression)aggregatingExpressions.get(expression);
            AggregationExpression partial = batch.add(aggregation, ExpressionUtil.replaceArrayProjections(expression.getInputExpression()));
            if (parent == null) {
                result = partial;
                continue;
            }
            parent.replace(expression, (EvaluationExpression)partial);
        }
        return result;
    }

    public static EvaluationExpression replaceArrayProjections(EvaluationExpression evaluationExpression) {
        return evaluationExpression.clone().remove(InputSelection.class).replace((Predicate<? super EvaluationExpression>)Predicates.instanceOf(ArrayProjection.class), new TransformFunction(){

            public EvaluationExpression apply(EvaluationExpression argument) {
                ArrayProjection arrayProjection = (ArrayProjection)argument;
                EvaluationExpression projection = arrayProjection.getProjection();
                return new ChainedSegmentExpression(arrayProjection.getInputExpression(), projection);
            }
        }).simplify();
    }

    public static EvaluationExpression replaceIndexAccessWithAggregation(EvaluationExpression baseExpression) {
        return baseExpression.replace((Predicate<? super EvaluationExpression>)Predicates.instanceOf(ArrayAccess.class), new TransformFunction(){

            public EvaluationExpression apply(EvaluationExpression argument) {
                ArrayAccess arrayAccess = (ArrayAccess)argument;
                if (!(arrayAccess.getInputExpression() instanceof InputSelection)) {
                    return arrayAccess;
                }
                if (arrayAccess.getStartIndex() < 0 || arrayAccess.getEndIndex() < 0) {
                    throw new IllegalArgumentException("Negative indexes cannot replaced currently");
                }
                if (arrayAccess.getStartIndex() > arrayAccess.getEndIndex()) {
                    throw new IllegalArgumentException("Array inversion is not directly supported");
                }
                if (arrayAccess.getStartIndex() == 0 && arrayAccess.getEndIndex() == 0) {
                    return new AggregationExpression(CoreFunctions.FIRST).withInputExpression(arrayAccess.getInputExpression());
                }
                return new AggregationExpression(new ArrayAccessAsAggregation(arrayAccess.getStartIndex(), arrayAccess.getEndIndex(), arrayAccess.isSelectingRange())).withInputExpression(arrayAccess.getInputExpression());
            }
        });
    }

    private static void findAggregatingFunctionCalls(EvaluationExpression expression, Map<FunctionCall, EvaluationExpression> aggregatingFunctionCalls, Map<AggregationExpression, EvaluationExpression> aggregatingExpressions, EvaluationExpression parent) {
        if (expression instanceof FunctionCall && ((FunctionCall)expression).getFunction() instanceof AggregationFunction) {
            aggregatingFunctionCalls.put((FunctionCall)expression, parent);
        } else if (expression instanceof AggregationExpression) {
            aggregatingExpressions.put((AggregationExpression)expression, parent);
        }
        for (EvaluationExpression child : expression) {
            ExpressionUtil.findAggregatingFunctionCalls(child, aggregatingFunctionCalls, aggregatingExpressions, expression);
        }
    }
}

