/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import eu.stratosphere.sopremo.AbstractSopremoType;
import eu.stratosphere.sopremo.ISopremoType;
import eu.stratosphere.sopremo.SingletonSerializer;
import eu.stratosphere.sopremo.expressions.ChainedSegmentExpression;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.expressions.TransformFunction;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.ListChildIterator;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.util.Immutable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class EvaluationExpression
extends AbstractSopremoType
implements ISopremoType,
Iterable<EvaluationExpression> {
    public static final PathSegmentExpression VALUE = new ValueExpression();

    public void appendAsString(Appendable appendable) throws IOException {
    }

    @Override
    public EvaluationExpression clone() {
        return (EvaluationExpression)super.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public abstract IJsonNode evaluate(IJsonNode var1);

    public <T extends EvaluationExpression> List<T> findAll(Class<T> evaluableClass) {
        return this.findAll((Predicate<? super EvaluationExpression>)Predicates.instanceOf(evaluableClass));
    }

    public List<EvaluationExpression> findAll(Predicate<? super EvaluationExpression> predicate) {
        ArrayList<EvaluationExpression> expressions = new ArrayList<EvaluationExpression>();
        this.findAll(predicate, expressions);
        return expressions;
    }

    public <T extends EvaluationExpression> T findFirst(Class<T> evaluableClass) {
        return (T)this.findFirst((Predicate<? super EvaluationExpression>)Predicates.instanceOf(evaluableClass));
    }

    public EvaluationExpression findFirst(Predicate<? super EvaluationExpression> predicate) {
        if (predicate.apply((Object)this)) {
            return this;
        }
        for (EvaluationExpression child : this) {
            EvaluationExpression expr = child.findFirst(predicate);
            if (expr == null) continue;
            return child.findFirst(predicate);
        }
        return null;
    }

    public int hashCode() {
        return 37;
    }

    public ChildIterator iterator() {
        List emptyList = Collections.EMPTY_LIST;
        return new ListChildIterator(emptyList.listIterator());
    }

    public String printAsTree() {
        StringBuilder builder = new StringBuilder();
        try {
            this.printAsTree(builder, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.toString();
    }

    public EvaluationExpression remove(Class<?> expressionType) {
        return this.remove((Predicate<? super EvaluationExpression>)Predicates.instanceOf(expressionType));
    }

    public EvaluationExpression remove(EvaluationExpression expressionToRemove) {
        return this.remove((Predicate<? super EvaluationExpression>)Predicates.equalTo((Object)expressionToRemove));
    }

    public EvaluationExpression remove(Predicate<? super EvaluationExpression> predicate) {
        if (predicate.apply((Object)this)) {
            return VALUE;
        }
        this.removeRecursively(predicate);
        return this;
    }

    public EvaluationExpression replace(EvaluationExpression toReplace, EvaluationExpression replaceFragment) {
        return this.replace((Predicate<? super EvaluationExpression>)Predicates.equalTo((Object)toReplace), replaceFragment);
    }

    public EvaluationExpression replace(Predicate<? super EvaluationExpression> replacePredicate, final EvaluationExpression replaceFragment) {
        return this.replace(replacePredicate, new TransformFunction(){

            public EvaluationExpression apply(EvaluationExpression argument) {
                return replaceFragment;
            }
        });
    }

    public EvaluationExpression replace(final Predicate<? super EvaluationExpression> replacePredicate, final Function<EvaluationExpression, EvaluationExpression> replaceFunction) {
        return this.transformRecursively(new TransformFunction(){

            public EvaluationExpression apply(EvaluationExpression evaluationExpression) {
                return replacePredicate.apply((Object)evaluationExpression) ? (EvaluationExpression)replaceFunction.apply((Object)evaluationExpression) : evaluationExpression;
            }
        });
    }

    public EvaluationExpression simplify() {
        ChildIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EvaluationExpression evaluationExpression = (EvaluationExpression)iterator.next();
            iterator.set(evaluationExpression.simplify());
        }
        return this;
    }

    public EvaluationExpression transformRecursively(Function<EvaluationExpression, EvaluationExpression> function) {
        ChildIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EvaluationExpression evaluationExpression = (EvaluationExpression)iterator.next();
            iterator.set(evaluationExpression.transformRecursively(function));
        }
        return (EvaluationExpression)function.apply((Object)this);
    }

    protected void printAsTree(Appendable appendable, int level) throws IOException {
        for (int index = 0; index < level; ++index) {
            appendable.append(' ');
        }
        appendable.append(this.getClass().getSimpleName()).append(' ');
        this.appendAsString(appendable);
        appendable.append('\n');
        for (EvaluationExpression child : this) {
            child.printAsTree(appendable, level + 1);
        }
    }

    private void findAll(Predicate<? super EvaluationExpression> predicate, ArrayList<EvaluationExpression> expressions) {
        if (predicate.apply((Object)this)) {
            expressions.add(this);
        }
        for (EvaluationExpression child : this) {
            child.findAll(predicate, expressions);
        }
    }

    private void removeRecursively(Predicate<? super EvaluationExpression> predicate) {
        ChildIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EvaluationExpression child = (EvaluationExpression)iterator.next();
            if (predicate.apply((Object)child)) {
                if (!iterator.canChildBeRemoved()) {
                    iterator.set(VALUE);
                    continue;
                }
                iterator.remove();
                continue;
            }
            child.removeRecursively(predicate);
        }
    }

    public static class ValueSerializer
    extends SingletonSerializer {
        public ValueSerializer() {
            super(VALUE);
        }
    }

    @DefaultSerializer(value=ValueSerializer.class)
    @Immutable
    public static final class ValueExpression
    extends PathSegmentExpression {
        @Override
        public void appendAsString(Appendable appendable) throws IOException {
            appendable.append('x');
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public boolean equalsSameClass(PathSegmentExpression other) {
            return true;
        }

        @Override
        public IJsonNode evaluate(IJsonNode node) {
            return node;
        }

        @Override
        public PathSegmentExpression getLast() {
            return this;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public ChildIterator iterator() {
            List emptyList = Collections.emptyList();
            return new ListChildIterator(emptyList.listIterator());
        }

        @Override
        public IJsonNode set(IJsonNode node, IJsonNode value) {
            return value;
        }

        @Override
        public void setInputExpression(EvaluationExpression inputExpression) {
            throw new IllegalStateException();
        }

        @Override
        public PathSegmentExpression withTail(EvaluationExpression tail) {
            if (tail instanceof PathSegmentExpression) {
                return (PathSegmentExpression)tail;
            }
            return new ChainedSegmentExpression(tail);
        }

        @Override
        protected IJsonNode evaluateSegment(IJsonNode node) {
            return node;
        }

        @Override
        protected int segmentHashCode() {
            return 0;
        }
    }
}

