/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.expressions.BinaryBooleanExpression;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.NamedChildIterator;
import eu.stratosphere.sopremo.type.BooleanNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

@OptimizerHints(scope={Scope.ANY}, iterating=true)
public class ElementInSetExpression
extends BinaryBooleanExpression {
    private EvaluationExpression elementExpr;
    private EvaluationExpression setExpr;
    private final Quantor quantor;

    public ElementInSetExpression(EvaluationExpression elementExpr, Quantor quantor, EvaluationExpression setExpr) {
        this.elementExpr = elementExpr;
        this.setExpr = setExpr;
        this.quantor = quantor;
    }

    ElementInSetExpression() {
        this.elementExpr = null;
        this.setExpr = null;
        this.quantor = null;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        this.elementExpr.appendAsString(appendable);
        appendable.append(this.quantor == Quantor.EXISTS_NOT_IN ? " \u2209 " : " \u2208 ");
        this.setExpr.appendAsString(appendable);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ElementInSetExpression other = (ElementInSetExpression)obj;
        return this.quantor == other.quantor && this.elementExpr.equals(other.elementExpr) && this.setExpr.equals(other.setExpr);
    }

    @Override
    public BooleanNode evaluate(IJsonNode node) {
        return this.quantor.evaluate(this.elementExpr.evaluate(node), ElementInSetExpression.asIterator(this.setExpr.evaluate(node)));
    }

    public EvaluationExpression getElementExpr() {
        return this.elementExpr;
    }

    @Override
    public EvaluationExpression getExpr1() {
        return this.elementExpr;
    }

    @Override
    public EvaluationExpression getExpr2() {
        return this.setExpr;
    }

    public Quantor getQuantor() {
        return this.quantor;
    }

    public EvaluationExpression getSetExpr() {
        return this.setExpr;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.elementExpr.hashCode();
        result = 31 * result + this.quantor.hashCode();
        result = 31 * result + this.setExpr.hashCode();
        return result;
    }

    @Override
    public ChildIterator iterator() {
        return new NamedChildIterator(new String[]{"elementExpr", "setExpr"}){

            @Override
            protected EvaluationExpression get(int index) {
                if (index == 0) {
                    return ElementInSetExpression.this.elementExpr;
                }
                return ElementInSetExpression.this.setExpr;
            }

            @Override
            protected void set(int index, EvaluationExpression childExpression) {
                if (index == 0) {
                    ElementInSetExpression.this.elementExpr = childExpression;
                } else {
                    ElementInSetExpression.this.setExpr = childExpression;
                }
            }
        };
    }

    static Iterator<IJsonNode> asIterator(IJsonNode evaluate) {
        if (evaluate instanceof IArrayNode) {
            return ((IArrayNode)evaluate).iterator();
        }
        return Arrays.asList(evaluate).iterator();
    }

    public static enum Quantor {
        EXISTS_IN,
        EXISTS_NOT_IN{

            @Override
            protected BooleanNode evaluate(IJsonNode element, Iterator<IJsonNode> set) {
                return super.evaluate(element, set).negate();
            }
        };


        protected BooleanNode evaluate(IJsonNode element, Iterator<IJsonNode> set) {
            while (set.hasNext()) {
                if (!element.equals(set.next())) continue;
                return BooleanNode.TRUE;
            }
            return BooleanNode.FALSE;
        }
    }
}

