/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.JsonUtil;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.NullNode;
import java.io.IOException;

@OptimizerHints(scope={Scope.ANY})
public class ConstantExpression
extends EvaluationExpression {
    private final IJsonNode constant;
    public static final EvaluationExpression MISSING = new ConstantExpression(MissingNode.getInstance());
    public static final EvaluationExpression NULL = new ConstantExpression(NullNode.getInstance());

    public ConstantExpression() {
        this.constant = null;
    }

    public ConstantExpression(IJsonNode constant) {
        this.constant = constant;
    }

    public ConstantExpression(Object constant) {
        this.constant = JsonUtil.OBJECT_MAPPER.map(constant);
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        if (this.constant instanceof CharSequence) {
            appendable.append("'");
            this.constant.appendAsString(appendable);
            appendable.append("'");
        } else {
            this.constant.appendAsString(appendable);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ConstantExpression other = (ConstantExpression)obj;
        return this.constant.equals(other.constant);
    }

    @Override
    public IJsonNode evaluate(IJsonNode node) {
        return this.constant;
    }

    public IJsonNode getConstant() {
        return this.constant;
    }

    @Override
    public int hashCode() {
        return 41 * super.hashCode() + this.constant.hashCode();
    }
}

