/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.expressions.BinaryBooleanExpression;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.NamedChildIterator;
import eu.stratosphere.sopremo.type.AbstractNumericNode;
import eu.stratosphere.sopremo.type.BooleanNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;

@OptimizerHints(scope={Scope.ANY}, minNodes=2, maxNodes=2)
public class ComparativeExpression
extends BinaryBooleanExpression {
    private EvaluationExpression expr1;
    private EvaluationExpression expr2;
    private final BinaryOperator binaryOperator;

    public ComparativeExpression(EvaluationExpression expr1, BinaryOperator binaryOperator, EvaluationExpression expr2) {
        this.expr1 = expr1;
        this.binaryOperator = binaryOperator;
        this.expr2 = expr2;
    }

    ComparativeExpression() {
        this.expr1 = null;
        this.binaryOperator = null;
        this.expr2 = null;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        this.expr1.appendAsString(appendable);
        appendable.append(' ').append(this.binaryOperator.sign).append(' ');
        this.expr2.appendAsString(appendable);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ComparativeExpression other = (ComparativeExpression)obj;
        return this.binaryOperator == other.binaryOperator && this.expr1.equals(other.expr1) && this.expr2.equals(other.expr2);
    }

    @Override
    public BooleanNode evaluate(IJsonNode node) {
        return BooleanNode.valueOf(this.binaryOperator.evaluate(this.expr1.evaluate(node), this.expr2.evaluate(node)));
    }

    public BinaryOperator getBinaryOperator() {
        return this.binaryOperator;
    }

    @Override
    public EvaluationExpression getExpr1() {
        return this.expr1;
    }

    @Override
    public EvaluationExpression getExpr2() {
        return this.expr2;
    }

    @Override
    public int hashCode() {
        int prime = 47;
        int result = super.hashCode();
        result = 47 * result + this.binaryOperator.hashCode();
        result = 47 * result + this.expr1.hashCode();
        result = 47 * result + this.expr2.hashCode();
        return result;
    }

    @Override
    public ChildIterator iterator() {
        return new NamedChildIterator(new String[]{"expr1", "expr2"}){

            @Override
            protected EvaluationExpression get(int index) {
                if (index == 0) {
                    return ComparativeExpression.this.expr1;
                }
                return ComparativeExpression.this.expr2;
            }

            @Override
            protected void set(int index, EvaluationExpression childExpression) {
                if (index == 0) {
                    ComparativeExpression.this.expr1 = childExpression;
                } else {
                    ComparativeExpression.this.expr2 = childExpression;
                }
            }
        };
    }

    public static enum BinaryOperator {
        EQUAL("="){

            @Override
            public boolean isTrue(int comparisonResult) {
                return comparisonResult == 0;
            }
        }
        ,
        NOT_EQUAL("<>"){

            @Override
            public boolean isTrue(int comparisonResult) {
                return comparisonResult != 0;
            }
        }
        ,
        LESS("<"){

            @Override
            public boolean isTrue(int comparisonResult) {
                return comparisonResult < 0;
            }
        }
        ,
        LESS_EQUAL("<="){

            @Override
            public boolean isTrue(int comparisonResult) {
                return comparisonResult <= 0;
            }
        }
        ,
        GREATER(">"){

            @Override
            public boolean isTrue(int comparisonResult) {
                return comparisonResult > 0;
            }
        }
        ,
        GREATER_EQUAL(">="){

            @Override
            public boolean isTrue(int comparisonResult) {
                return comparisonResult >= 0;
            }
        };

        private final String sign;

        private BinaryOperator(String sign) {
            this.sign = sign;
        }

        public boolean evaluate(IJsonNode e1, IJsonNode e2) {
            if (e1.getClass() != e2.getClass()) {
                if (e1 instanceof AbstractNumericNode && e2 instanceof AbstractNumericNode) {
                    return this.isTrue(e1.compareTo(e2));
                }
                return false;
            }
            return this.isTrue(e1.compareToSameType(e2));
        }

        public abstract boolean isTrue(int var1);

        public String toString() {
            return this.sign;
        }

        public static BinaryOperator valueOfSymbol(String sign) {
            for (BinaryOperator operator : BinaryOperator.values()) {
                if (!operator.sign.equals(sign)) continue;
                return operator;
            }
            return null;
        }
    }
}

