/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.cache.NodeCache;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.TypeCoercer;
import java.io.IOException;
import javolution.text.TextFormat;

@OptimizerHints(scope={Scope.NUMBER})
public class CoerceExpression
extends PathSegmentExpression {
    private final Class<IJsonNode> targetType;
    private final transient NodeCache nodeCache = new NodeCache();

    public CoerceExpression(Class<? extends IJsonNode> targetType) {
        if (targetType == null) {
            throw new NullPointerException();
        }
        this.targetType = targetType;
    }

    CoerceExpression() {
        this.targetType = null;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append('(');
        TextFormat.getInstance(Class.class).format(this.targetType, appendable);
        appendable.append(')');
        if (this.getInputExpression() != EvaluationExpression.VALUE) {
            appendable.append(' ');
            this.getInputExpression().appendAsString(appendable);
        }
    }

    @Override
    public boolean equalsSameClass(PathSegmentExpression other) {
        return this.targetType.equals(((CoerceExpression)other).targetType);
    }

    @Override
    public CoerceExpression withInputExpression(EvaluationExpression inputExpression) {
        return (CoerceExpression)super.withInputExpression(inputExpression);
    }

    @Override
    protected IJsonNode evaluateSegment(IJsonNode node) {
        return TypeCoercer.INSTANCE.coerce(node, this.nodeCache, this.targetType);
    }

    @Override
    protected int segmentHashCode() {
        return this.targetType.hashCode();
    }
}

