/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.ListChildIterator;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ChainedSegmentExpression
extends PathSegmentExpression {
    private final List<EvaluationExpression> expressions;

    public ChainedSegmentExpression() {
        this.expressions = new ArrayList<EvaluationExpression>();
    }

    public ChainedSegmentExpression(Collection<? extends EvaluationExpression> expressions) {
        this.expressions = new ArrayList<EvaluationExpression>(expressions);
    }

    public ChainedSegmentExpression(EvaluationExpression ... expressions) {
        this(Arrays.asList(expressions));
    }

    public void addExpression(EvaluationExpression expression) {
        this.expressions.add(expression);
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        this.appendInputAsString(appendable);
        this.append(appendable, this.expressions, "->");
    }

    @Override
    public boolean equalsSameClass(PathSegmentExpression other) {
        return this.expressions.equals(((ChainedSegmentExpression)other).expressions);
    }

    public List<EvaluationExpression> getExpressions() {
        return this.expressions;
    }

    @Override
    public ChildIterator iterator() {
        return new ListChildIterator(this.expressions.listIterator());
    }

    @Override
    public EvaluationExpression simplify() {
        this.expressions.removeAll(Arrays.asList(EvaluationExpression.VALUE));
        switch (this.expressions.size()) {
            case 0: {
                return EvaluationExpression.VALUE;
            }
            case 1: {
                return this.expressions.get(0).simplify();
            }
        }
        return super.simplify();
    }

    @Override
    protected IJsonNode evaluateSegment(IJsonNode node) {
        IJsonNode result = node;
        for (EvaluationExpression expression : this.expressions) {
            result = expression.evaluate(result);
        }
        return result;
    }

    @Override
    protected int segmentHashCode() {
        return this.expressions.hashCode();
    }
}

