/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import eu.stratosphere.sopremo.EvaluationException;
import eu.stratosphere.sopremo.aggregation.Aggregation;
import eu.stratosphere.sopremo.expressions.AggregationExpression;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.ExpressionUtil;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.ConcatenatingChildIterator;
import eu.stratosphere.sopremo.function.ExpressionFunction;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IStreamNode;
import eu.stratosphere.sopremo.type.MissingNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class BatchAggregationExpression
extends PathSegmentExpression {
    private final List<Partial> partials;
    private final transient IArrayNode<IJsonNode> results = new ArrayNode<IJsonNode>();
    private static final ThreadLocal<Map<BatchAggregationExpression, CloneHelper>> CLONE_MAP = new ThreadLocal<Map<BatchAggregationExpression, CloneHelper>>(){

        @Override
        protected Map<BatchAggregationExpression, CloneHelper> initialValue() {
            return new IdentityHashMap<BatchAggregationExpression, CloneHelper>();
        }
    };

    public BatchAggregationExpression() {
        this.partials = new ArrayList<Partial>();
    }

    public BatchAggregationExpression(Aggregation ... functions) {
        this(Arrays.asList(functions));
    }

    public BatchAggregationExpression(List<Aggregation> functions) {
        this.partials = new ArrayList<Partial>(functions.size());
        for (Aggregation function : functions) {
            this.partials.add(new Partial(this, function, this.partials.size()));
        }
    }

    public AggregationExpression add(Aggregation function) {
        return this.add(function.clone(), (EvaluationExpression)EvaluationExpression.VALUE);
    }

    public AggregationExpression add(Aggregation function, EvaluationExpression preprocessing) {
        Partial partial = new Partial(this, function.clone(), this.partials.size()).withInputExpression(preprocessing);
        this.partials.add(partial);
        return partial;
    }

    public EvaluationExpression add(ExpressionFunction aggregation) {
        return this.add(aggregation, (EvaluationExpression)EvaluationExpression.VALUE);
    }

    public EvaluationExpression add(ExpressionFunction aggregation, EvaluationExpression preprocessing) {
        return aggregation.inline(preprocessing).replace((Predicate<? super EvaluationExpression>)Predicates.instanceOf(AggregationExpression.class), new Function<EvaluationExpression, EvaluationExpression>(){

            public EvaluationExpression apply(EvaluationExpression expression) {
                AggregationExpression ae = (AggregationExpression)expression;
                return BatchAggregationExpression.this.add(ae.getAggregation(), ExpressionUtil.replaceArrayProjections(ae.getInputExpression()));
            }
        });
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        this.getInputExpression().appendAsString(appendable);
        appendable.append('^');
    }

    @Override
    public boolean equalsSameClass(PathSegmentExpression other) {
        return this.partials.equals(((BatchAggregationExpression)other).partials);
    }

    public EvaluationExpression get(int index) {
        return this.partials.get(index);
    }

    @Override
    protected IJsonNode evaluateSegment(IJsonNode node) {
        IStreamNode stream = (IStreamNode)node;
        if (stream.isEmpty()) {
            return this.results;
        }
        this.results.clear();
        for (Partial partial : this.partials) {
            partial.getAggregation().initialize();
        }
        for (IJsonNode input : stream) {
            for (Partial partial : this.partials) {
                IJsonNode preprocessedValue = partial.getInputExpression().evaluate(input);
                if (preprocessedValue == MissingNode.getInstance()) {
                    throw new EvaluationException(String.format("Cannot access %s for aggregation %s on %s", partial.getInputExpression(), partial, input));
                }
                partial.getAggregation().aggregate(preprocessedValue);
            }
        }
        for (int index = 0; index < this.partials.size(); ++index) {
            this.results.add(this.partials.get(index).getAggregation().getFinalAggregate());
        }
        return this.results;
    }

    @Override
    protected int segmentHashCode() {
        return this.partials.hashCode();
    }

    Partial getPartial(int index) {
        return this.partials.get(index);
    }

    private static BatchAggregationExpression getClone(BatchAggregationExpression expression, Partial partial) {
        Map<BatchAggregationExpression, CloneHelper> map = CLONE_MAP.get();
        CloneHelper cloneHelper = map.get(expression);
        if (cloneHelper == null || cloneHelper.clonedPartials.get(partial.index)) {
            cloneHelper = new CloneHelper((BatchAggregationExpression)expression.clone());
            map.put(expression, cloneHelper);
        }
        cloneHelper.clonedPartials.set(partial.index);
        return cloneHelper.clone;
    }

    private static class CloneHelper {
        private final BatchAggregationExpression clone;
        private final BitSet clonedPartials = new BitSet();

        public CloneHelper(BatchAggregationExpression clone) {
            this.clone = clone;
        }
    }

    static final class Partial
    extends AggregationExpression {
        private final int index;
        private final BatchAggregationExpression bae;

        public Partial(BatchAggregationExpression bae, Aggregation function, int index) {
            super(function);
            this.bae = bae;
            this.index = index;
        }

        Partial() {
            this.bae = null;
            this.index = 0;
        }

        @Override
        public void appendAsString(Appendable appendable) throws IOException {
            this.getAggregation().appendAsString(appendable);
            appendable.append('(');
            this.bae.appendAsString(appendable);
            if (this.getInputExpression() != EvaluationExpression.VALUE) {
                this.getInputExpression().appendAsString(appendable);
            }
            appendable.append(')');
        }

        @Override
        public PathSegmentExpression clone() {
            return (PathSegmentExpression)BatchAggregationExpression.getClone(this.bae, this).partials.get(this.index);
        }

        @Override
        public boolean equalsSameClass(PathSegmentExpression other) {
            return super.equalsSameClass(other) && this.bae.getInputExpression().equals(((Partial)other).bae.getInputExpression());
        }

        @Override
        public IJsonNode evaluate(IJsonNode node) {
            return ((IArrayNode)this.bae.evaluate(node)).get(this.index);
        }

        @Override
        public ChildIterator iterator() {
            return new ConcatenatingChildIterator(super.iterator(), this.bae.iterator());
        }

        @Override
        public Partial withInputExpression(EvaluationExpression inputExpression) {
            return (Partial)super.withInputExpression(inputExpression);
        }

        @Override
        protected int segmentHashCode() {
            return super.segmentHashCode() + 43 * this.bae.getInputExpression().hashCode();
        }

        BatchAggregationExpression getBatch() {
            return this.bae;
        }
    }
}

