/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.expressions.ChainedSegmentExpression;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.ConcatenatingChildIterator;
import eu.stratosphere.sopremo.expressions.tree.NamedChildIterator;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IStreamNode;
import eu.stratosphere.sopremo.type.PullingStreamNode;
import java.io.IOException;

@OptimizerHints(scope={Scope.ARRAY}, iterating=true)
public class ArrayProjection
extends PathSegmentExpression {
    private EvaluationExpression projection;
    private final transient IArrayNode<IJsonNode> materializedResult = new ArrayNode<IJsonNode>();
    private final transient PullingStreamNode<?> virtualResult = new PullingStreamNode();

    public ArrayProjection(EvaluationExpression projection) {
        this.projection = projection;
    }

    protected ArrayProjection() {
        this(EvaluationExpression.VALUE);
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append("proj(x in ");
        this.getInputExpression().appendAsString(appendable);
        appendable.append(", ");
        this.projection.appendAsString(appendable);
        appendable.append(")");
    }

    @Override
    public boolean equalsSameClass(PathSegmentExpression other) {
        return this.projection.equals(((ArrayProjection)other).projection);
    }

    public EvaluationExpression getProjection() {
        return this.projection;
    }

    @Override
    public ChildIterator iterator() {
        return new ConcatenatingChildIterator(super.iterator(), new NamedChildIterator(new String[]{"projection"}){

            @Override
            protected EvaluationExpression get(int index) {
                return ArrayProjection.this.projection;
            }

            @Override
            protected void set(int index, EvaluationExpression childExpression) {
                ArrayProjection.this.projection = childExpression;
            }
        });
    }

    @Override
    public EvaluationExpression simplify() {
        if (this.getInputExpression() instanceof ArrayProjection) {
            ArrayProjection arrayProjection = (ArrayProjection)this.getInputExpression();
            return new ArrayProjection(new ChainedSegmentExpression(arrayProjection.getProjection(), this.getProjection())).withInputExpression(arrayProjection.getInputExpression()).simplify();
        }
        return super.simplify();
    }

    @Override
    public ArrayProjection withInputExpression(EvaluationExpression inputExpression) {
        return (ArrayProjection)super.withInputExpression(inputExpression);
    }

    @Override
    protected IJsonNode evaluateSegment(IJsonNode node) {
        if (!(node instanceof IArrayNode)) {
            this.virtualResult.setSource((IStreamNode)node);
            this.virtualResult.setExpression(this.projection);
            return this.virtualResult;
        }
        IArrayNode array = (IArrayNode)node;
        this.materializedResult.clear();
        int size = array.size();
        for (int index = 0; index < size; ++index) {
            this.materializedResult.add(this.projection.evaluate((IJsonNode)array.get(index)));
        }
        return this.materializedResult;
    }

    @Override
    protected int segmentHashCode() {
        return this.projection.hashCode();
    }
}

