/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.NullNode;
import java.io.IOException;

@OptimizerHints(scope={Scope.ARRAY}, transitive=true, minNodes=1, maxNodes=0x7FFFFFFF, iterating=true)
public class ArrayMerger
extends EvaluationExpression {
    private final transient IArrayNode<IJsonNode> result = new ArrayNode<IJsonNode>();

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append("[*]+...+[*]");
    }

    @Override
    public IJsonNode evaluate(IJsonNode node) {
        this.result.clear();
        for (IJsonNode nextNode : (IArrayNode)node) {
            if (nextNode == NullNode.getInstance()) continue;
            IArrayNode array = (IArrayNode)nextNode;
            for (int index = 0; index < array.size(); ++index) {
                if (this.result.size() <= index) {
                    this.result.add((IJsonNode)array.get(index));
                    continue;
                }
                if (!this.isNull(this.result.get(index)) || this.isNull((IJsonNode)array.get(index))) continue;
                this.result.set(index, (IJsonNode)array.get(index));
            }
        }
        return this.result;
    }

    private boolean isNull(IJsonNode value) {
        return value == MissingNode.getInstance() || value == NullNode.getInstance();
    }
}

