/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.ListChildIterator;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@OptimizerHints(scope={Scope.ANY})
public class ArrayCreation
extends EvaluationExpression {
    private final List<EvaluationExpression> elements;
    private final IArrayNode<IJsonNode> result = new ArrayNode<IJsonNode>();

    public ArrayCreation() {
        this.elements = new ArrayList<EvaluationExpression>();
    }

    public ArrayCreation(EvaluationExpression ... elements) {
        this.elements = new ArrayList<EvaluationExpression>(Arrays.asList(elements));
    }

    public ArrayCreation(List<EvaluationExpression> elements) {
        this.elements = new ArrayList<EvaluationExpression>(elements);
    }

    public ArrayCreation add(EvaluationExpression expression) {
        this.elements.add(expression);
        return this;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append('[');
        this.append(appendable, this.elements, ", ");
        appendable.append(']');
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ArrayCreation other = (ArrayCreation)obj;
        return this.elements.equals(other.elements);
    }

    @Override
    public IJsonNode evaluate(IJsonNode node) {
        this.result.clear();
        for (int index = 0; index < this.elements.size(); ++index) {
            this.result.add(this.elements.get(index).evaluate(node));
        }
        return this.result;
    }

    public EvaluationExpression get(int index) {
        return this.elements.get(index);
    }

    public List<EvaluationExpression> getElements() {
        return this.elements;
    }

    @Override
    public int hashCode() {
        return 53 * super.hashCode() + this.elements.hashCode();
    }

    @Override
    public ChildIterator iterator() {
        return new ListChildIterator(this.elements.listIterator());
    }

    public int size() {
        return this.elements.size();
    }
}

