/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.expressions.ArrayCreation;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.NullNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javolution.text.TypeFormat;

@OptimizerHints(scope={Scope.ARRAY}, iterating=true)
public class ArrayAccess
extends PathSegmentExpression {
    private final int startIndex;
    private final int endIndex;
    private final transient IArrayNode<IJsonNode> result = new ArrayNode<IJsonNode>();

    public ArrayAccess() {
        this(0, -1);
    }

    public ArrayAccess(int index) {
        this(index, index);
    }

    public ArrayAccess(int startIndex, int endIndex) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        this.getInputExpression().appendAsString(appendable);
        appendable.append('[');
        if (this.isSelectingAll()) {
            appendable.append('*');
        } else {
            TypeFormat.format((int)this.startIndex, (Appendable)appendable);
            if (this.startIndex != this.endIndex) {
                appendable.append(':');
                TypeFormat.format((int)this.endIndex, (Appendable)appendable);
            }
        }
        appendable.append(']');
    }

    public Collection<ArrayAccess> decompose() {
        if (!this.isFixedSize()) {
            throw new IllegalStateException("Not decomposable");
        }
        if (!this.isSelectingRange()) {
            return Arrays.asList(this);
        }
        ArrayList<ArrayAccess> accesses = new ArrayList<ArrayAccess>();
        for (int index = this.startIndex; index <= this.endIndex; ++index) {
            accesses.add(new ArrayAccess(index));
        }
        return accesses;
    }

    @Override
    public boolean equalsSameClass(PathSegmentExpression obj) {
        ArrayAccess other = (ArrayAccess)obj;
        return this.startIndex == other.startIndex && this.endIndex == other.endIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int[] getIndices() {
        if (!this.isFixedSize()) {
            return null;
        }
        if (this.startIndex >= 0) {
            int[] indices = new int[this.endIndex - this.startIndex + 1];
            for (int index = this.startIndex; index <= this.endIndex; ++index) {
                indices[index - this.startIndex] = index;
            }
            return indices;
        }
        int[] indices = new int[-this.startIndex - this.endIndex + 1];
        for (int index = this.startIndex; index <= this.endIndex; ++index) {
            indices[this.startIndex - index] = index;
        }
        return indices;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public boolean isFixedSize() {
        return this.startIndex >= 0 == this.endIndex >= 0;
    }

    public boolean isSelectingAll() {
        return this.startIndex == 0 && this.endIndex == -1;
    }

    public boolean isSelectingRange() {
        return this.startIndex != this.endIndex;
    }

    @Override
    protected IJsonNode evaluateSegment(IJsonNode node) {
        if (!(node instanceof IArrayNode)) {
            return MissingNode.getInstance();
        }
        IArrayNode arrayNode = (IArrayNode)node;
        if (this.isSelectingAll()) {
            this.result.clear();
            this.result.addAll(arrayNode);
            return this.result;
        }
        int size = arrayNode.size();
        if (this.isSelectingRange()) {
            this.result.clear();
            int index = this.resolveIndex(this.startIndex, size);
            int endIndex = this.resolveIndex(this.endIndex, size);
            int increment = index < endIndex ? 1 : -1;
            boolean moreElements = true;
            while (moreElements) {
                this.result.add((IJsonNode)arrayNode.get(index));
                moreElements = index != endIndex;
                index += increment;
            }
            return this.result;
        }
        Object value = arrayNode.get(this.resolveIndex(this.startIndex, size));
        return value == null ? NullNode.getInstance() : value;
    }

    @Override
    protected int segmentHashCode() {
        return this.startIndex * 47 + this.endIndex;
    }

    @Override
    protected IJsonNode setSegment(IJsonNode node, IJsonNode value) {
        if (this.isSelectingAll()) {
            return value;
        }
        IArrayNode arrayNode = (IArrayNode)node;
        int size = arrayNode.size();
        if (this.isSelectingRange()) {
            int index = this.resolveIndex(this.startIndex, size);
            int replaceIndex = 0;
            int endIndex = this.resolveIndex(this.endIndex, size);
            int increment = index < endIndex ? 1 : -1;
            IArrayNode otherArray = (IArrayNode)node;
            boolean moreElements = true;
            while (moreElements) {
                SopremoUtil.replaceWithCopy(arrayNode, index, otherArray.get(replaceIndex));
                moreElements = index != endIndex;
                index += increment;
                ++replaceIndex;
            }
        } else {
            SopremoUtil.replaceWithCopy(arrayNode, this.resolveIndex(this.startIndex, size), value);
        }
        return node;
    }

    private int resolveIndex(int index, int size) {
        if (index < 0) {
            return size + index;
        }
        return index;
    }

    public static EvaluationExpression arrayWithIndices(int ... indices) {
        switch (indices.length) {
            case 0: {
                return new ArrayCreation();
            }
            case 1: {
                return new ArrayCreation(new ArrayAccess(indices[0]));
            }
        }
        boolean monoton = true;
        int step = indices[1] - indices[0];
        if (Math.abs(step) != 1) {
            monoton = false;
        }
        for (int index = 2; monoton && index < indices.length; index += step) {
            monoton = indices[index] - indices[index - 1] == step;
        }
        if (monoton) {
            return new ArrayAccess(indices[0], indices[indices.length - 1]);
        }
        ArrayAccess[] accesses = new ArrayAccess[indices.length];
        for (int index = 0; index < indices.length; ++index) {
            accesses[index] = new ArrayAccess(indices[index]);
        }
        return new ArrayCreation();
    }
}

