/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.cache.NodeCache;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.NamedChildIterator;
import eu.stratosphere.sopremo.type.BigIntegerNode;
import eu.stratosphere.sopremo.type.DecimalNode;
import eu.stratosphere.sopremo.type.DoubleNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.INumericNode;
import eu.stratosphere.sopremo.type.IntNode;
import eu.stratosphere.sopremo.type.LongNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.IdentityHashMap;
import java.util.Map;

@OptimizerHints(scope={Scope.NUMBER}, minNodes=2, maxNodes=2, transitive=true)
public class ArithmeticExpression
extends EvaluationExpression {
    private final ArithmeticOperator operator;
    private EvaluationExpression firstOperand;
    private EvaluationExpression secondOperand;
    private final transient NodeCache cache = new NodeCache();

    public ArithmeticExpression(EvaluationExpression op1, ArithmeticOperator operator, EvaluationExpression op2) {
        this.operator = operator;
        this.firstOperand = op1;
        this.secondOperand = op2;
    }

    ArithmeticExpression() {
        this.operator = null;
        this.firstOperand = null;
        this.secondOperand = null;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        this.firstOperand.appendAsString(appendable);
        appendable.append(' ');
        appendable.append(this.operator.name());
        appendable.append(' ');
        this.secondOperand.appendAsString(appendable);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ArithmeticExpression other = (ArithmeticExpression)obj;
        return this.firstOperand.equals(other.firstOperand) && this.operator.equals((Object)other.operator) && this.secondOperand.equals(other.secondOperand);
    }

    @Override
    public IJsonNode evaluate(IJsonNode node) {
        return this.operator.evaluate((INumericNode)this.firstOperand.evaluate(node), (INumericNode)this.secondOperand.evaluate(node), this.cache);
    }

    public EvaluationExpression getFirstOperand() {
        return this.firstOperand;
    }

    public ArithmeticOperator getOperator() {
        return this.operator;
    }

    public EvaluationExpression getSecondOperand() {
        return this.secondOperand;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 59 * result + this.firstOperand.hashCode();
        result = 59 * result + this.operator.hashCode();
        result = 59 * result + this.secondOperand.hashCode();
        return result;
    }

    @Override
    public ChildIterator iterator() {
        return new NamedChildIterator(new String[]{"firstOperand", "second"}){

            @Override
            protected EvaluationExpression get(int index) {
                if (index == 0) {
                    return ArithmeticExpression.this.firstOperand;
                }
                return ArithmeticExpression.this.secondOperand;
            }

            @Override
            protected void set(int index, EvaluationExpression childExpression) {
                if (index == 0) {
                    ArithmeticExpression.this.firstOperand = childExpression;
                } else {
                    ArithmeticExpression.this.secondOperand = childExpression;
                }
            }
        };
    }

    private static interface NumberEvaluator<ReturnType extends INumericNode> {
        public void evaluate(INumericNode var1, INumericNode var2, ReturnType var3);

        public Class<ReturnType> getReturnType();
    }

    private static abstract class LongEvaluator
    implements NumberEvaluator<LongNode> {
        private LongEvaluator() {
        }

        @Override
        public void evaluate(INumericNode left, INumericNode right, LongNode numericTarget) {
            numericTarget.setValue(this.evaluate(left.getLongValue(), right.getLongValue()));
        }

        @Override
        public Class<LongNode> getReturnType() {
            return LongNode.class;
        }

        protected abstract long evaluate(long var1, long var3);
    }

    private static abstract class IntegerEvaluator
    implements NumberEvaluator<IntNode> {
        private IntegerEvaluator() {
        }

        @Override
        public void evaluate(INumericNode left, INumericNode right, IntNode numericTarget) {
            numericTarget.setValue(this.evaluate(left.getIntValue(), right.getIntValue()));
        }

        @Override
        public Class<IntNode> getReturnType() {
            return IntNode.class;
        }

        protected abstract int evaluate(int var1, int var2);
    }

    private static abstract class DoubleEvaluator
    implements NumberEvaluator<DoubleNode> {
        private DoubleEvaluator() {
        }

        @Override
        public void evaluate(INumericNode left, INumericNode right, DoubleNode numericTarget) {
            numericTarget.setValue(this.evaluate(left.getDoubleValue(), right.getDoubleValue()));
        }

        @Override
        public Class<DoubleNode> getReturnType() {
            return DoubleNode.class;
        }

        protected abstract double evaluate(double var1, double var3);
    }

    private static abstract class BigIntegerEvaluator
    implements NumberEvaluator<BigIntegerNode> {
        private BigIntegerEvaluator() {
        }

        @Override
        public void evaluate(INumericNode left, INumericNode right, BigIntegerNode numericTarget) {
            numericTarget.setValue(this.evaluate(left.getBigIntegerValue(), right.getBigIntegerValue()));
        }

        @Override
        public Class<BigIntegerNode> getReturnType() {
            return BigIntegerNode.class;
        }

        protected abstract BigInteger evaluate(BigInteger var1, BigInteger var2);
    }

    private static abstract class BigDecimalEvaluator
    implements NumberEvaluator<DecimalNode> {
        private BigDecimalEvaluator() {
        }

        @Override
        public void evaluate(INumericNode left, INumericNode right, DecimalNode numericTarget) {
            numericTarget.setValue(this.evaluate(left.getDecimalValue(), right.getDecimalValue()));
        }

        @Override
        public Class<DecimalNode> getReturnType() {
            return DecimalNode.class;
        }

        protected abstract BigDecimal evaluate(BigDecimal var1, BigDecimal var2);
    }

    static class DivisionEvaluator
    implements NumberEvaluator<DecimalNode> {
        private static final DivisionEvaluator INSTANCE = new DivisionEvaluator();
        public static final int DIVISION_EXTRA_PRECISION = 10;
        public static final int DIVISION_MIN_SCALE = 10;

        DivisionEvaluator() {
        }

        @Override
        public void evaluate(INumericNode left, INumericNode right, DecimalNode numericTarget) {
            numericTarget.setValue(DivisionEvaluator.divideImpl(left.getDecimalValue(), right.getDecimalValue()));
        }

        @Override
        public Class<DecimalNode> getReturnType() {
            return DecimalNode.class;
        }

        public static BigDecimal divideImpl(BigDecimal bigLeft, BigDecimal bigRight) {
            try {
                return bigLeft.divide(bigRight);
            }
            catch (ArithmeticException e) {
                int precision = Math.max(bigLeft.precision(), bigRight.precision()) + 10;
                BigDecimal result = bigLeft.divide(bigRight, new MathContext(precision));
                int scale = Math.max(Math.max(bigLeft.scale(), bigRight.scale()), 10);
                if (result.scale() > scale) {
                    result = result.setScale(scale, 4);
                }
                return result;
            }
        }

        static /* synthetic */ DivisionEvaluator access$700() {
            return INSTANCE;
        }
    }

    public static enum ArithmeticOperator {
        ADDITION("+", new IntegerEvaluator(){

            @Override
            protected int evaluate(int left, int right) {
                return left + right;
            }
        }, new LongEvaluator(){

            @Override
            protected long evaluate(long left, long right) {
                return left + right;
            }
        }, new DoubleEvaluator(){

            @Override
            protected double evaluate(double left, double right) {
                return left + right;
            }
        }, new BigIntegerEvaluator(){

            @Override
            protected BigInteger evaluate(BigInteger left, BigInteger right) {
                return left.add(right);
            }
        }, new BigDecimalEvaluator(){

            @Override
            protected BigDecimal evaluate(BigDecimal left, BigDecimal right) {
                return left.add(right);
            }
        }),
        SUBTRACTION("-", new IntegerEvaluator(){

            @Override
            protected int evaluate(int left, int right) {
                return left - right;
            }
        }, new LongEvaluator(){

            @Override
            protected long evaluate(long left, long right) {
                return left - right;
            }
        }, new DoubleEvaluator(){

            @Override
            protected double evaluate(double left, double right) {
                return left - right;
            }
        }, new BigIntegerEvaluator(){

            @Override
            protected BigInteger evaluate(BigInteger left, BigInteger right) {
                return left.subtract(right);
            }
        }, new BigDecimalEvaluator(){

            @Override
            protected BigDecimal evaluate(BigDecimal left, BigDecimal right) {
                return left.subtract(right);
            }
        }),
        MULTIPLICATION("*", new IntegerEvaluator(){

            @Override
            protected int evaluate(int left, int right) {
                return left * right;
            }
        }, new LongEvaluator(){

            @Override
            protected long evaluate(long left, long right) {
                return left * right;
            }
        }, new DoubleEvaluator(){

            @Override
            protected double evaluate(double left, double right) {
                return left * right;
            }
        }, new BigIntegerEvaluator(){

            @Override
            protected BigInteger evaluate(BigInteger left, BigInteger right) {
                return left.multiply(right);
            }
        }, new BigDecimalEvaluator(){

            @Override
            protected BigDecimal evaluate(BigDecimal left, BigDecimal right) {
                return left.multiply(right);
            }
        }),
        DIVISION("/", DivisionEvaluator.access$700(), DivisionEvaluator.access$700(), new DoubleEvaluator(){

            @Override
            protected double evaluate(double left, double right) {
                return left / right;
            }
        }, DivisionEvaluator.access$700(), DivisionEvaluator.access$700());

        private final String sign;
        private final Map<Class<? extends INumericNode>, NumberEvaluator<INumericNode>> typeEvaluators = new IdentityHashMap<Class<? extends INumericNode>, NumberEvaluator<INumericNode>>();

        private ArithmeticOperator(String sign, NumberEvaluator integerEvaluator, NumberEvaluator longEvaluator, NumberEvaluator doubleEvaluator, NumberEvaluator bigIntegerEvaluator, NumberEvaluator bigDecimalEvaluator) {
            this.sign = sign;
            this.typeEvaluators.put(IntNode.class, integerEvaluator);
            this.typeEvaluators.put(LongNode.class, longEvaluator);
            this.typeEvaluators.put(DoubleNode.class, doubleEvaluator);
            this.typeEvaluators.put(BigIntegerNode.class, bigIntegerEvaluator);
            this.typeEvaluators.put(DecimalNode.class, bigDecimalEvaluator);
        }

        public INumericNode evaluate(INumericNode left, INumericNode right, NodeCache cache) {
            Class<?> widerType = (left.getGeneralilty() > right.getGeneralilty() ? left : right).getClass();
            NumberEvaluator<INumericNode> evaluator = this.typeEvaluators.get(widerType);
            Class<INumericNode> implementationType = evaluator.getReturnType();
            INumericNode numericTarget = cache.getNode(implementationType);
            evaluator.evaluate(left, right, numericTarget);
            return numericTarget;
        }

        public String toString() {
            return this.sign;
        }
    }
}

