/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.expressions.BooleanExpression;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.OptimizerHints;
import eu.stratosphere.sopremo.expressions.Scope;
import eu.stratosphere.sopremo.expressions.tree.ChildIterator;
import eu.stratosphere.sopremo.expressions.tree.GenericListChildIterator;
import eu.stratosphere.sopremo.type.BooleanNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@OptimizerHints(scope={Scope.ANY})
public class AndExpression
extends BooleanExpression {
    private final List<BooleanExpression> expressions;

    public AndExpression() {
        this(new ArrayList());
    }

    public AndExpression(BooleanExpression ... expressions) {
        this(Arrays.asList(expressions));
    }

    public AndExpression(List<? extends BooleanExpression> expressions) {
        this.expressions = new ArrayList<BooleanExpression>(expressions);
    }

    public AndExpression addExpression(BooleanExpression expression) {
        this.expressions.add(expression);
        return this;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append("(");
        this.append(appendable, this.expressions, " AND ");
        appendable.append(")");
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AndExpression other = (AndExpression)obj;
        return this.expressions.equals(other.expressions);
    }

    @Override
    public BooleanNode evaluate(IJsonNode node) {
        for (EvaluationExpression evaluationExpression : this.expressions) {
            if (evaluationExpression.evaluate(node) != BooleanNode.FALSE) continue;
            return BooleanNode.FALSE;
        }
        return BooleanNode.TRUE;
    }

    public List<BooleanExpression> getExpressions() {
        return this.expressions;
    }

    @Override
    public int hashCode() {
        int prime = 41;
        int result = super.hashCode();
        result = 41 * result + this.expressions.hashCode();
        return result;
    }

    @Override
    public ChildIterator iterator() {
        return new GenericListChildIterator<BooleanExpression>(this.expressions.listIterator()){

            @Override
            protected BooleanExpression convert(EvaluationExpression childExpression) {
                return BooleanExpression.ensureBooleanExpression(childExpression);
            }
        };
    }

    public static AndExpression valueOf(BooleanExpression expression) {
        if (expression instanceof AndExpression) {
            return (AndExpression)expression;
        }
        return new AndExpression(expression);
    }

    public static AndExpression valueOf(List<? extends EvaluationExpression> childConditions) {
        List<BooleanExpression> booleanExpressions = BooleanExpression.ensureBooleanExpressions(childConditions);
        if (booleanExpressions.size() == 1) {
            return AndExpression.valueOf(booleanExpressions.get(0));
        }
        return new AndExpression(booleanExpressions.toArray(new BooleanExpression[booleanExpressions.size()]));
    }
}

