/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.expressions;

import eu.stratosphere.sopremo.aggregation.Aggregation;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.expressions.PathSegmentExpression;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.IStreamNode;
import java.io.IOException;

public class AggregationExpression
extends PathSegmentExpression {
    private final Aggregation aggregation;

    public AggregationExpression(Aggregation aggregation) {
        this.aggregation = aggregation.clone();
    }

    AggregationExpression() {
        this.aggregation = null;
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        this.aggregation.appendAsString(appendable);
        appendable.append('(');
        if (this.getInputExpression() != EvaluationExpression.VALUE) {
            this.getInputExpression().appendAsString(appendable);
        }
        appendable.append(')');
    }

    @Override
    public boolean equalsSameClass(PathSegmentExpression other) {
        return this.aggregation.equals(((AggregationExpression)other).aggregation);
    }

    public Aggregation getAggregation() {
        return this.aggregation;
    }

    @Override
    public AggregationExpression withInputExpression(EvaluationExpression inputExpression) {
        return (AggregationExpression)super.withInputExpression(inputExpression);
    }

    @Override
    protected IJsonNode evaluateSegment(IJsonNode nodes) {
        this.aggregation.initialize();
        for (IJsonNode node : (IStreamNode)nodes) {
            this.aggregation.aggregate(node);
        }
        return this.aggregation.getFinalAggregate();
    }

    @Override
    protected int segmentHashCode() {
        return this.aggregation.hashCode();
    }
}

