/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.execution;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.sopremo.execution.SopremoID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ExecutionResponse
implements IOReadableWritable {
    private ExecutionState state;
    private String details;
    private SopremoID jobId;

    public ExecutionResponse() {
    }

    public ExecutionResponse(SopremoID jobId, ExecutionState state, String response) {
        this.jobId = jobId;
        this.state = state;
        this.details = response;
    }

    public String getDetails() {
        return this.details;
    }

    public SopremoID getJobId() {
        return this.jobId;
    }

    public ExecutionState getState() {
        return this.state;
    }

    public void read(DataInput in) throws IOException {
        this.jobId = new SopremoID();
        this.jobId.read(in);
        this.state = ExecutionState.values()[in.readInt()];
        this.details = in.readUTF();
    }

    public void write(DataOutput out) throws IOException {
        this.jobId.write(out);
        out.writeInt(this.state.ordinal());
        out.writeUTF(this.details);
    }

    public static enum ExecutionState {
        SETUP,
        ENQUEUED,
        RUNNING,
        FINISHED,
        ERROR;

    }
}

