/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.execution;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoCopyable;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.nephele.execution.librarycache.LibraryCacheManager;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.sopremo.SopremoEnvironment;
import eu.stratosphere.sopremo.operator.SopremoPlan;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ExecutionRequest
implements KryoSerializable,
KryoCopyable<ExecutionRequest>,
IOReadableWritable {
    private SopremoPlan query;
    private ExecutionMode mode = ExecutionMode.RUN;

    public ExecutionRequest() {
    }

    public ExecutionRequest(SopremoPlan query) {
        this.query = query;
    }

    public ExecutionRequest copy(Kryo kryo) {
        ExecutionRequest er = new ExecutionRequest(this.query);
        er.setMode(this.mode);
        return er;
    }

    public ExecutionMode getMode() {
        return this.mode;
    }

    public SopremoPlan getQuery() {
        return this.query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(DataInput in) throws IOException {
        this.mode = ExecutionMode.values()[in.readInt()];
        ArrayList<String> requiredPackages = new ArrayList<String>();
        for (int count = in.readInt(); count > 0; --count) {
            requiredPackages.add(in.readUTF());
        }
        this.query = null;
        byte[] planBuffer = new byte[in.readInt()];
        in.readFully(planBuffer);
        JobID dummId = new JobID();
        try {
            LibraryCacheManager.register((JobID)dummId, (String[])requiredPackages.toArray(new String[requiredPackages.size()]));
            SopremoEnvironment.getInstance().setClassLoader(LibraryCacheManager.getClassLoader((JobID)dummId));
            this.query = SopremoUtil.deserialize(planBuffer, SopremoPlan.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                LibraryCacheManager.unregister((JobID)dummId);
            }
            catch (IOException e) {}
        }
    }

    public void read(Kryo kryo, Input input) {
        this.mode = (ExecutionMode)((Object)kryo.readObject(input, ExecutionMode.class));
        ArrayList requiredPackages = (ArrayList)kryo.readObject(input, ArrayList.class);
        JobID dummId = JobID.generate();
        ClassLoader oldClassLoader = kryo.getClassLoader();
        try {
            LibraryCacheManager.register((JobID)dummId, (String[])requiredPackages.toArray(new String[requiredPackages.size()]));
            kryo.setClassLoader(LibraryCacheManager.getClassLoader((JobID)dummId));
            this.query = (SopremoPlan)kryo.readObject(input, SopremoPlan.class);
        }
        catch (Exception e) {
            SopremoUtil.LOG.error((Object)e.getMessage());
            throw new KryoException((Throwable)e);
        }
        finally {
            kryo.setClassLoader(oldClassLoader);
            try {
                LibraryCacheManager.unregister((JobID)dummId);
            }
            catch (Throwable e) {
                SopremoUtil.LOG.error((Object)e.getMessage());
            }
        }
    }

    public void setMode(ExecutionMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode must not be null");
        }
        this.mode = mode;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.mode.ordinal());
        List<String> requiredPackages = this.query.getRequiredPackages();
        out.writeInt(requiredPackages.size());
        for (String packageName : requiredPackages) {
            out.writeUTF(packageName);
        }
        byte[] planBuffer = SopremoUtil.serializable(this.query);
        out.writeInt(planBuffer.length);
        out.write(planBuffer);
    }

    public void write(Kryo kryo, Output output) {
        kryo.writeObject(output, (Object)this.mode);
        kryo.writeObject(output, new ArrayList<String>(this.query.getRequiredPackages()));
        kryo.writeObject(output, (Object)this.query);
    }

    public static enum ExecutionMode {
        RUN,
        RUN_WITH_STATISTICS;

    }
}

