/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.cache;

import eu.stratosphere.sopremo.cache.ISopremoCache;
import eu.stratosphere.sopremo.type.DefaultNodeFactory;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.NodeFactory;
import java.util.IdentityHashMap;
import java.util.Map;

public final class NodeCache
implements ISopremoCache {
    private final transient Map<Class<? extends IJsonNode>, IJsonNode> classCache = new IdentityHashMap<Class<? extends IJsonNode>, IJsonNode>();
    private final NodeFactory nodeFactory;

    public NodeCache() {
        this(DefaultNodeFactory.getInstance());
    }

    public NodeCache(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public NodeCache clone() {
        return new NodeCache();
    }

    public IJsonNode clone(IJsonNode node) {
        Object clone = this.getNode(node.getClass());
        clone.copyValueFrom(node);
        return clone;
    }

    public <T extends IJsonNode> T getNode(Class<T> type) {
        IJsonNode cachedValue = this.classCache.get(type);
        if (cachedValue != null) {
            return (T)cachedValue;
        }
        T newValue = this.nodeFactory.instantiate(type);
        this.classCache.put((Class<? extends IJsonNode>)type, (IJsonNode)newValue);
        return newValue;
    }
}

